package tk.eclipse.plugin.struts;

import java.util.ArrayList;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;

public class StrutsProjectNature implements IProjectNature {
	
	private IProject project;
	
	public StrutsProjectNature() {
		super();
	}

	public void configure() throws CoreException {
		IProjectDescription desc = project.getDescription();
		ICommand[] commands = desc.getBuildSpec();
		for(int i=0;i<commands.length;i++){
			if(commands[i].getBuilderName().equals(StrutsPlugin.STRUTS_PROJECT_BUILDER)){
				return;
			}
		}
		ICommand command = desc.newCommand();
		command.setBuilderName(StrutsPlugin.STRUTS_PROJECT_BUILDER);
		ICommand[] newCommands = new ICommand[commands.length + 1];
		for(int i=0;i<commands.length;i++){
			newCommands[i] = commands[i];
		}
		newCommands[newCommands.length - 1] = command;
		desc.setBuildSpec(newCommands);
		project.setDescription(desc,null);
	}

	public void deconfigure() throws CoreException {
		IProjectDescription desc = project.getDescription();
		ICommand[] commands = desc.getBuildSpec();
		ArrayList list = new ArrayList();
		for(int i=0;i<commands.length;i++){
			if(!commands[i].getBuilderName().equals(StrutsPlugin.STRUTS_PROJECT_BUILDER)){
				list.add(commands[i]);
			}
		}
		desc.setBuildSpec((ICommand[])list.toArray(new ICommand[list.size()]));
		project.setDescription(desc,null);
	}

	public IProject getProject() {
		return project;
	}

	public void setProject(IProject project) {
		this.project = project;
	}

}
