package tk.eclipse.plugin.struts;

import java.io.InputStream;
import java.util.Iterator;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.struts.editors.models.PluginModel;
import tk.eclipse.plugin.struts.editors.models.RootModel;
import tk.eclipse.plugin.struts.editors.models.TilesRootModel;
import tk.eclipse.plugin.struts.properties.Properties;

/**
 * A utility class to generate model objects from tiles-defs.xml (XML documnt).
 * This uses SAX parsing, but processing is fuzzy.
 * The parsing is INCOMPLETE and for one way usage.
 * 
 * @author Naoki Takezoe
 */
public class TilesDefsXML2Model {
	
    private final static String TILES_PLUGIN_CLASSNAME = "org.apache.struts.tiles.TilesPlugin";
    private final static String TILES_PLUGIN_DEFINITION_CONFIG_PROPERTY = "definitions-config";
    
	/**
	 * Generates (simplified and incomplete) RootModel from tiles-defs files configured in struts-config.xml.
	 * 
	 * @param the eclipse project
	 * @param the model generated from the struts-config.xml
	 * @return the (possibly empty) TilesRootModel
	 */
	public static TilesRootModel createModel(IProject project, RootModel strutsModel){
        
        TilesRootModel tilesModel = new TilesRootModel();
        StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(false);
		try {
            String[] tilesFilenames = getTilesDefsFilenames(strutsModel);
            if (tilesFilenames != null) {
                SAXParserFactory spfactory = SAXParserFactory.newInstance();
                spfactory.setValidating(false);
                HTMLProjectParams params = new HTMLProjectParams(project);

                for (int i=0; i<tilesFilenames.length; i++) {
                    IPath path = new Path(params.getRoot()).append(tilesFilenames[i]);
                    IFile file = project.getFile(path);
                    InputStream in = file.getContents();
                    
                    SAXParser parser = spfactory.newSAXParser();
                    XMLReader reader = parser.getXMLReader(); 
                    
                    TilesDefsSAXHandler handler = new TilesDefsSAXHandler();
                    
                    reader.setEntityResolver(new StrutsConfigResolver());
                    reader.setContentHandler(handler);
                    reader.setProperty("http://xml.org/sax/properties/lexical-handler",handler);
                    reader.parse(new InputSource(in));
                    
                    tilesModel.merge(handler.getModel());
                }
            }
		} catch(Exception ex){
			Util.logException(ex);
		} finally {
			StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(true);
		}
		return tilesModel;
	}

	/**
	 * Returns Tiles configuration filenames from <code>RootModel</code>.
	 * 
	 * @param root the <code>RootModel</code> of the struts-config.xml
	 * @return Tiles configuration filenames
	 */
    public static String[] getTilesDefsFilenames(RootModel root) {
        Iterator it = root.getChildren().iterator();
        while (it.hasNext()) {
            Object model = it.next();
            if (model instanceof PluginModel) {
                PluginModel plugin = (PluginModel) model;
                if (TILES_PLUGIN_CLASSNAME.equals(plugin.getClassName())) {
                    Properties props = plugin.getProperties();
                    for (int i=0; i<props.size(); i++) {
                        if (TILES_PLUGIN_DEFINITION_CONFIG_PROPERTY.equals(props.getName(i))) {
                            String[] fileNames = props.getValue(i).split(",");
                            for(int j=0;j<fileNames.length;j++){
                            	fileNames[j] = fileNames[j].trim();
                            }
                            return fileNames;
                        }
                    }
                    return new String[0];
                }
            }
        }
        return null;
    }

}
