package tk.eclipse.plugin.struts.editors;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.LayerConstants;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.PlatformUI;

import tk.eclipse.plugin.struts.StrutsPlugin;

/**
 * @author Naoki Takezoe
 */
public class SaveAsImageAction extends Action {
	
	private GraphicalViewer viewer;
	
	public SaveAsImageAction(GraphicalViewer viewer){
		super(StrutsPlugin.getResourceString("action.saveAsImage"),
				StrutsPlugin.getDefault().getImageRegistry().getDescriptor(StrutsPlugin.ICON_SAVE_IMAGE));
		this.viewer = viewer;
	}
	
//	public void update(IStructuredSelection sel){
//	}
	
	public void run(){
		ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart)viewer.getRootEditPart();
		double zoom = rootEditPart.getZoomManager().getZoom();
		
		try {
			FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), SWT.SAVE);
			dialog.setFileName(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getTitle() + ".jpg");
			String file = dialog.open();
			if(file!=null){
				rootEditPart.getZoomManager().setZoomAsText(ZoomManager.FIT_ALL);
				
				IFigure figure = rootEditPart.getLayer(LayerConstants.PRINTABLE_LAYERS);
				
				Rectangle rectangle = figure.getBounds();
				
				Image image = new Image(Display.getDefault(), rectangle.width + 50, rectangle.height + 50);
				GC gc = new GC(image);
				SWTGraphics graphics = new SWTGraphics(gc);
				figure.paint(graphics);
				
				ImageLoader loader = new ImageLoader();
				loader.data = new ImageData[]{image.getImageData()};
				
				if(file.endsWith(".bmp")){
					loader.save(file, SWT.IMAGE_BMP);
//				} else if(file.endsWith(".gif")){
//					loader.save(file, SWT.IMAGE_GIF);
				} else if(file.endsWith(".jpg") || file.endsWith(".jpeg")){
					loader.save(file, SWT.IMAGE_JPEG);
//				} else if(file.endsWith(".png")){
//					loader.save(file, SWT.IMAGE_PNG);
//				} else if(file.endsWith(".tiff")){
//					loader.save(file, SWT.IMAGE_TIFF);
				} else {
					file = file + ".bmp";
					loader.save(file, SWT.IMAGE_BMP);
				}
				
				image.dispose();
				gc.dispose();
			}
		} catch(Exception ex){
			//ex.printStackTrace();
		} finally {
			rootEditPart.getZoomManager().setZoom(zoom);
		}
	}
		
}
