package tk.eclipse.plugin.struts.editors;

import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.XPath;

import org.eclipse.jface.text.TextSelection;

import tk.eclipse.plugin.struts.StrutsConfigResolver;
import tk.eclipse.plugin.xmleditor.editors.XMLEditor;

/**
 * The extended <code>XMLEditor</code> for struts-config.xml.
 * 
 * @author Naoki Takezoe
 * @see tk.eclipse.plugin.struts.StrutsConfigResolver
 */
public class StrutsConfigXMLEditor extends XMLEditor {
	
	private static final String[] CLASS_ATTRIBUTES = {
		"type","className", "processorClass", "handler", 
		"multipartClass", "factory"
	};
	
	/**
	 * The constructor.
	 * <p>
	 * Invokes <code>setValidation(false)</code> and
	 * <code>addDTDResolver(new StrutsConfigResolver())</code>.
	 */
	public StrutsConfigXMLEditor() {
		super();
		setValidation(false);
		addDTDResolver(new StrutsConfigResolver());
	}
	
	public String[] getClassNameAttributes(){
		return CLASS_ATTRIBUTES;
	}

	public boolean setFocusAttrValue(String tagName, String attrName,
            String targetAttrValue) {
		FuzzyXMLDocument doc = new FuzzyXMLParser().parse(getHTMLSource());
		FuzzyXMLNode[] formBeanNodes = XPath.selectNodes(doc.getDocumentElement(), tagName);
		for(int i=0;i<formBeanNodes.length;i++){
			if(formBeanNodes[i] instanceof FuzzyXMLElement){
				FuzzyXMLElement e = (FuzzyXMLElement) formBeanNodes[i];
				FuzzyXMLAttribute attr = e.getAttributeNode(attrName);
				if (attr != null && attr.getValue().equals(targetAttrValue)) {
					int offset = attr.getOffset();
					int length = attr.getLength();
					getSelectionProvider().setSelection(new TextSelection(offset + length, 0-targetAttrValue.length()-2));
					return true;
				}
			}
		}
		return false;
	}
}
