package tk.eclipse.plugin.struts.editors;

import java.util.ArrayList;

import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IFileEditorInput;

import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.assist.AssistInfo;
import tk.eclipse.plugin.htmleditor.assist.AttributeInfo;
import tk.eclipse.plugin.htmleditor.assist.HTMLAssistProcessor;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;
import tk.eclipse.plugin.struts.StrutsConfigResolver;
import tk.eclipse.plugin.xmleditor.editors.XMLAssistProcessor;
import tk.eclipse.plugin.xmleditor.editors.XMLConfiguration;
import tk.eclipse.plugin.xmleditor.editors.XMLEditor;

/**
 * XML Editor for Tiles configuration files.
 * 
 * @author Naoki Takezoe
 */
public class TilesXMLEditor extends XMLEditor {
	
	private static final String[] CLASS_ATTRIBUTES = {
		"controllerClass", "classtype"
	};
	
	public TilesXMLEditor(){
		super(new TilesConfiguration());
		addDTDResolver(new StrutsConfigResolver());
		setValidation(false);
	}
	
	public String[] getClassNameAttributes() {
		return CLASS_ATTRIBUTES;
	}
	
	/**
	 * SourceEditor Configuration for the Tiles Editor.
	 */
	private static class TilesConfiguration extends XMLConfiguration {
		
		public TilesConfiguration(){
			super(HTMLPlugin.getDefault().getColorProvider());
		}
		
		protected HTMLAssistProcessor createAssistProcessor() {
			return new TilesAssistProcessor();
		}
	}
	
	/**
	 * AssistProcessor for Tiles configuration files.
	 */
	private static class TilesAssistProcessor extends XMLAssistProcessor {
		
		private IProject project;
//		private ArrayList defNames = new ArrayList();
		
		public void update(HTMLSourceEditor editor, String source) {
			super.update(editor, source);
			if(editor.getEditorInput() instanceof IFileEditorInput){
				this.project = ((IFileEditorInput)editor.getEditorInput()).getFile().getProject();
			}
			
//			// get definition names
//			try {
//				defNames.clear();
//				
//				FuzzyXMLDocument doc = new FuzzyXMLParser().parse(input.getFile().getContents());
//				FuzzyXMLNode[] nodes = HTMLUtil.selectXPathNodes(
//						doc.getDocumentElement(),"//tiles-definitions/definition");
//				for(int i=0;i<nodes.length;i++){
//					FuzzyXMLElement element = (FuzzyXMLElement)nodes[i];
//					defNames.add(element.getAttributeNode("name").getValue());
//				}
//			} catch(Exception ex){
//				Util.logException(ex);
//			}
		}
		
		protected AssistInfo[] getAttributeValues(String tagName, String value,AttributeInfo info) {
			if(tagName.equals("definition") && info.getAttributeName().equals("path")){
				return getFiles(value);
			}
			if(tagName.equals("definition") && info.getAttributeName().equals("extends")){
				return getDefinitionNames();
			}
			if(tagName.equals("put") && info.getAttributeName().equals("value")){
				return getFiles(value);
			}
			return super.getAttributeValues(tagName, value, info);
		}
		
		private AssistInfo[] getDefinitionNames(){
			FuzzyXMLDocument doc = getDocument();
			FuzzyXMLNode[] nodes = HTMLUtil.selectXPathNodes(
					doc.getDocumentElement(),"//tiles-definitions/definition");
			
			ArrayList defNames = new ArrayList();
			for(int i=0;i<nodes.length;i++){
				FuzzyXMLElement element = (FuzzyXMLElement)nodes[i];
				defNames.add(element.getAttributeNode("name").getValue());
			}

			AssistInfo[] assist = new AssistInfo[defNames.size()];
			for(int i=0;i<assist.length;i++){
				assist[i] = new AssistInfo((String)defNames.get(i));
			}
			return assist;
		}
		
		private AssistInfo[] getFiles(String value){
			
			IPath  path   = null;
			String parent = null;;
			
			// complete if value starts with "/"
			if(value.startsWith("/")){
				try {
					HTMLProjectParams params = new HTMLProjectParams(project);
					path = new Path(params.getRoot());
				} catch(Exception ex){
					HTMLPlugin.logException(ex);
				}
			} else {
				return new AssistInfo[0];
			}
			
			int index = value.lastIndexOf('/');
			if(index >= 0){
				path   = path.append(value.substring(0,index));
				parent = value.substring(0,index) + "/";
			} else{
				parent = "";
			}
			IResource resource = project.findMember(path);
			if(resource!=null && resource.exists() && resource instanceof IContainer){
				try {
					IContainer container = (IContainer)resource;
					IResource[] children = container.members();
					ArrayList list = new ArrayList();
					for(int i=0;i<children.length;i++){
						// ignore dot files
						if(children[i].getName().startsWith(".")){
							continue;
						}
						// ignore non-JSP files
						if(children[i] instanceof IFile && !children[i].getName().endsWith(".jsp")){
							continue;
						}
						Image image = null;
						if(children[i] instanceof IContainer){
							image = HTMLPlugin.getDefault().getImageRegistry().get(HTMLPlugin.ICON_FOLDER);
						} else {
							image = getFileImage(children[i].getName().toLowerCase());
						}
						
						list.add(new AssistInfo(
								parent + children[i].getName(),
								children[i].getName(),
								image
						));
					}
					return (AssistInfo[])list.toArray(new AssistInfo[list.size()]);
				} catch(Exception ex){
					HTMLPlugin.logException(ex);
				}
			}
			return new AssistInfo[0];
		}
		
		private Image getFileImage(String name){
			if(name.endsWith(".jsp")){
				return HTMLPlugin.getDefault().getImageRegistry().get(HTMLPlugin.ICON_JSP);
			}
			return HTMLPlugin.getDefault().getImageRegistry().get(HTMLPlugin.ICON_FILE);
		}
	}
	
}
