package tk.eclipse.plugin.struts.editors.editparts;

import java.beans.PropertyChangeEvent;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.RequestConstants;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

import tk.eclipse.plugin.htmleditor.gefutils.LabelArrowConnection;
import tk.eclipse.plugin.struts.editors.models.ExceptionModel;

/**
 * An EditPart of ExceptionModel.
 * 
 * @author Naoki Takezoe
 */
public class ExceptionEditPart extends AbstractStrutsConnectionEditPart {
	
	private ExceptionDirectEditManager directManager;
	
	public ExceptionEditPart(){
	}
	
	protected IFigure createFigure() {
		ExceptionModel model = (ExceptionModel)getModel();
		String name = model.getType();
		if(name.equals("")){
			name = "<exception>";
		}
		
		LabelArrowConnection connection = new LabelArrowConnection(Display.getCurrent().getSystemColor(SWT.COLOR_RED));
		connection.setText(name);
		addDefaultBendpoints();
		
		return connection;
	}
	
	protected void createEditPolicies() {
		super.createEditPolicies();
		installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE, new ExceptionDirectEditPolicy());
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		super.propertyChange(evt);
		String propName = evt.getPropertyName();
		if(propName.equals(ExceptionModel.P_TYPE)){
			String type = (String)evt.getNewValue();
			if(type.equals("")){
				type = "<exception>";
			}
			LabelArrowConnection connection = (LabelArrowConnection)getFigure();
			connection.setText(type);
			refreshVisuals();
		}
	}
	
	public void performRequest(Request req) {
		if (req.getType().equals(RequestConstants.REQ_DIRECT_EDIT)) {
			performDirectEdit();
			return;
		}
		super.performRequest(req);
	}
	
	private void performDirectEdit() {
		if (directManager == null) {
			directManager = new ExceptionDirectEditManager(
					TextCellEditor.class,
					new ExceptionCellEditorLocator(getFigure()));
		}
		directManager.show();
	}
	
	/**
	 * DirectEditManager
	 */
	private class ExceptionDirectEditManager extends DirectEditManager {
		
		public ExceptionDirectEditManager(Class editorType,CellEditorLocator locator) {
			super(ExceptionEditPart.this, editorType, locator);
		}
		
		protected void initCellEditor() {
			getCellEditor().setValue(((ExceptionModel)getModel()).getType());
			Text text = (Text) getCellEditor().getControl();
			text.selectAll();
		}
	}
	
	/**
	 * CellEditorLocator
	 */
	private class ExceptionCellEditorLocator implements CellEditorLocator {
		
		private IFigure figure;
		
		public ExceptionCellEditorLocator(IFigure f) {
			figure = f;
		}
		
		public void relocate(CellEditor celleditor) {
			Text text = (Text) celleditor.getControl();
			//Point pref = text.computeSize(-1, -1);
			Rectangle rect = ((LabelArrowConnection)figure).getLabel().getBounds().getCopy();
			figure.translateToAbsolute(rect);
			text.setBounds(rect.x, rect.y, rect.width, rect.height);
		}
	}
	
	/**
	 * DirectEditCommand
	 */
	private class DirectEditCommand extends Command {
		
		private String oldType;
		private String newType;
		
		public void execute() {
			ExceptionModel model = (ExceptionModel)getModel();
			oldType = model.getType();
			model.setType(newType);
		}
		
		public void setType(String type) {
			newType = type;
		}
		
		public void undo() {
			ExceptionModel model = (ExceptionModel)getModel();
			model.setType(oldType);
		}
	}
	
	/**
	 * DirectEditPolicy
	 */
	private class ExceptionDirectEditPolicy extends DirectEditPolicy {
		
		protected Command getDirectEditCommand(DirectEditRequest request) {
			DirectEditCommand command = new DirectEditCommand();
			command.setType((String) request.getCellEditor().getValue());
			return command;
		}
		
		protected void showCurrentEditValue(DirectEditRequest request) {
		}
	}
}
