package tk.eclipse.plugin.struts.editors.editparts;

import java.beans.PropertyChangeEvent;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.RequestConstants;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Text;

import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.TilesDefsXML2Model;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.editors.models.PageModel;

/** EditPart of PageModel */
public class PageEditPart extends AbstractEntityEditPart {
    
	private PageDirectEditManager directManager;
	private String moduleName;
	
	public PageEditPart(IFile file, String moduleName){
		super(file);
		this.moduleName = moduleName;
	}
	
	public void setModel(Object model){
		super.setModel(model);
		((PageModel)model).setModuleName(moduleName);
	}
	
    protected IFigure createFigure() {
		PageModel model = (PageModel) getModel();
		String path = model.getPath();
		if(path.equals("")){
			path = "<page>";
		}
		
		Label label = new Label();
		label.setText(path);
		if(exists(model.getPath(), moduleName)){
			label.setIcon(StrutsPlugin.getDefault().getImage(StrutsPlugin.IMAGE_WEBPAGE));
		} else {
			label.setIcon(StrutsPlugin.getDefault().getImage(StrutsPlugin.IMAGE_WEBPAGE_WARN));
		}
		label.setTextPlacement(PositionConstants.SOUTH);

		return label;
	}
    
	protected void createEditPolicies() {
		super.createEditPolicies();
		installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE, new PageDirectEditPolicy());
	}
    
	protected void refreshVisuals(){
		super.refreshVisuals();
		Label label = (Label)getFigure();
		PageModel model = (PageModel) getModel();
		if(exists(model.getPath(), moduleName)){
			label.setIcon(StrutsPlugin.getDefault().getImage(StrutsPlugin.IMAGE_WEBPAGE));
		} else {
			label.setIcon(StrutsPlugin.getDefault().getImage(StrutsPlugin.IMAGE_WEBPAGE_WARN));
		}
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		super.propertyChange(evt);
		String propName = evt.getPropertyName();
		Label label = (Label)getFigure();
		if(propName.equals(PageModel.P_PATH)){
			String path = (String)evt.getNewValue();
			if(path.equals("")){
				path = "<page>";
			}
			label.setText(path);
		}
		
		PageModel model = (PageModel) getModel();
		if(exists(model.getPath(), moduleName)){
			label.setIcon(StrutsPlugin.getDefault().getImage(StrutsPlugin.IMAGE_WEBPAGE));
		} else {
			label.setIcon(StrutsPlugin.getDefault().getImage(StrutsPlugin.IMAGE_WEBPAGE_WARN));
		}
	}
	
	public boolean exists(String path, String moduleName){
		try {
			if(path==null || path.equals("")){
				return false;
			}
			if(path.indexOf('{') >= 0){
				return true;
			}
			if(path.indexOf("?")>0){
				path = path.substring(0,path.indexOf("?"));
			}
			
			IProject project = getFile().getProject();
            /* (MVL) changed
			String[] tilesDefinitions = new StrutsProject(project).getTilesDefinition();
			for(int i=0;i<tilesDefinitions.length;i++){
				if(tilesDefinitions[i].equals(path)){
					return true;
				}
			}
            // (MVL) to */
            PageModel model = (PageModel) getModel();
            if(model.getRoot().getTilesRoot()==null){
            	model.getRoot().setTilesRoot(TilesDefsXML2Model.createModel(project, model.getRoot()));
            }
            if (model.getRoot().getTilesRoot().existsDefinition(path)) {
                return true;
            }
            // (MVL) end
			
			if(moduleName!=null && !moduleName.equals("")){
				if(!path.startsWith("/")){
					path = "/" + path;
				}
				path = "/" + moduleName + path;
			}
			
			HTMLProjectParams params = new HTMLProjectParams(project);
			if(project.getFile(new Path(params.getRoot()).append(path)).exists()){
				return true;
			}
		} catch(Exception ex){
		}
		return false;
	}
	
	public void performRequest(Request req) {
		if (req.getType().equals(RequestConstants.REQ_DIRECT_EDIT)) {
			performDirectEdit();
			return;
		}  else if (req.getType().equals(RequestConstants.REQ_OPEN)) {
            performOpen();
            return;
        }
		super.performRequest(req);
	}
	
	private void performOpen() {
		Util.openPage(getFile().getProject(), (PageModel)getModel());
	}

	private void performDirectEdit() {
		if (directManager == null) {
			directManager = new PageDirectEditManager(
						TextCellEditor.class,
						new PageCellEditorLocator(getFigure()));
		}
		directManager.show();
	}
	
	/**
	 * DirectEditManager
	 */
	private class PageDirectEditManager extends DirectEditManager {
		
		public PageDirectEditManager(Class editorType,CellEditorLocator locator) {
			super(PageEditPart.this, editorType, locator);
		}
		
		protected void initCellEditor() {
			getCellEditor().setValue(((PageModel)getModel()).getPath());
			Text text = (Text) getCellEditor().getControl();
			text.selectAll();
		}
	}
	
	/**
	 * CellEditorLocator
	 */
	private class PageCellEditorLocator implements CellEditorLocator {
		
		private IFigure figure;
		
		public PageCellEditorLocator(IFigure f) {
			figure = f;
		}
		
		public void relocate(CellEditor celleditor) {
			Text text = (Text) celleditor.getControl();
			//Point pref = text.computeSize(-1, -1);
			Rectangle rect = figure.getBounds().getCopy();
			figure.translateToAbsolute(rect);
			text.setBounds(rect.x, rect.y + 32, rect.width, rect.height - 32);
		}
	}
	
	/**
	 * DirectEditCommand
	 */
	private class DirectEditCommand extends Command {
		
		private String oldPath;
		private String newPath;
		
		public void execute() {
			PageModel model = (PageModel)getModel();
			oldPath = model.getPath();
			model.setPath(newPath);
		}
		
		public void setPath(String path) {
			newPath = path;
		}
		
		public void undo() {
			PageModel model = (PageModel)getModel();
			model.setPath(oldPath);
		}
	}
	
	/**
	 * DirectEditPolicy
	 */
	private class PageDirectEditPolicy extends DirectEditPolicy {
		
		protected Command getDirectEditCommand(DirectEditRequest request) {
			DirectEditCommand command = new DirectEditCommand();
			command.setPath((String) request.getCellEditor().getValue());
			return command;
		}
		
		protected void showCurrentEditValue(DirectEditRequest request) {
		}
	}

}
