package tk.eclipse.plugin.struts.editors.editparts;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToGeometry;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToGuides;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.rulers.RulerProvider;

import tk.eclipse.plugin.struts.editors.models.AbstractEntityModel;
import tk.eclipse.plugin.struts.editors.models.AbstractModel;
import tk.eclipse.plugin.struts.editors.models.RootModel;

public class RootEditPart extends AbstractStrutsConfigEditPart {

	protected IFigure createFigure() {
		Layer figure = new FreeformLayer();
        figure.setLayoutManager(new FreeformLayout());
	    return figure;
	}
	
	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.LAYOUT_ROLE, new RootEditPolicy());
	}
	
	protected List getModelChildren() {
	    List list = ((RootModel)getModel()).getViasualChildren();
	    ArrayList models = new ArrayList();
	    for(int i=0;i<list.size();i++){
	        Object obj = list.get(i);
	        if(obj instanceof AbstractModel){
	            models.add(obj);
	        }
	    }
	    return models;
	}
	
	public void refreshVisuals(){
		List list = getChildren();
		for(int i=0;i<list.size();i++){
			Object obj = list.get(i);
			if(obj instanceof PageEditPart || obj instanceof ActionEditPart){
				((AbstractEntityEditPart)obj).refreshVisuals();
			}
		}
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		if (evt.getPropertyName().equals(RootModel.P_CHILDREN)) {
			refreshChildren();
		}
	}
	
	/** EditPolicy */
	private class RootEditPolicy extends XYLayoutEditPolicy {
		protected EditPolicy createChildEditPolicy(EditPart child) {
			return new NonResizableEditPolicy();
		}
		protected Command createAddCommand(EditPart child, Object constraint) {
			return null;
		}		
		protected Command createChangeConstraintCommand(EditPart child,Object constraint) {
			ChangeConstraintCommand command = new ChangeConstraintCommand();
			command.setModel((AbstractEntityModel)child.getModel());
			command.setConstraint((Rectangle)constraint);
			return command;
		}
		protected Command getCreateCommand(CreateRequest request) {
		    CreateCommand command = new CreateCommand();
		    Rectangle constraint = (Rectangle) getConstraintFor(request);
		    constraint.width = -1;
		    constraint.height = -1;
		    AbstractEntityModel model = (AbstractEntityModel) request.getNewObject();
		    model.setConstraint(constraint);

		    command.setRootModel(getHost().getModel());
		    command.setModel(model);
		    return command;
		}
		protected Command getDeleteDependantCommand(Request request) {
			return null;
		}
	}
	/** Change constraint command */
	private class ChangeConstraintCommand extends Command {
		private AbstractEntityModel model;
		private Rectangle constraint;
		private Rectangle oldConstraint;
		public void execute(){
			model.setConstraint(constraint);
		}
		public void setConstraint(Rectangle constraint){
			this.constraint = constraint;
		}
		public void setModel(AbstractEntityModel model){
			this.model = model;
			oldConstraint = model.getConstraint();
		}
		public void undo() {
			model.setConstraint(oldConstraint);
		}
	}
	/** Create new model command */
	private class CreateCommand extends Command {
		private RootModel root;
		private AbstractEntityModel model;
		public void execute() {
			root.addChild(model);
		}
		public void setRootModel(Object root) {
			this.root = (RootModel)root;
		}
		public void setModel(Object model) {
			this.model = (AbstractEntityModel) model;
		}
		public void undo() {
			root.removeChild(model);
		}
	}
	
	/**
	 * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class adapter) {
		if (adapter == SnapToHelper.class) {
			List snapStrategies = new ArrayList();
			Boolean val = (Boolean)getViewer().getProperty(RulerProvider.PROPERTY_RULER_VISIBILITY);
			if (val != null && val.booleanValue())
				snapStrategies.add(new SnapToGuides(this));
			val = (Boolean)getViewer().getProperty(SnapToGeometry.PROPERTY_SNAP_ENABLED);
			if (val != null && val.booleanValue())
				snapStrategies.add(new SnapToGeometry(this));
			val = (Boolean)getViewer().getProperty(SnapToGrid.PROPERTY_GRID_ENABLED);
			if (val != null && val.booleanValue())
				snapStrategies.add(new SnapToGrid(this));
			
			if (snapStrategies.size() == 0)
				return null;
			if (snapStrategies.size() == 1)
				return (SnapToHelper)snapStrategies.get(0);

			SnapToHelper ss[] = new SnapToHelper[snapStrategies.size()];
			for (int i = 0; i < snapStrategies.size(); i++)
				ss[i] = (SnapToHelper)snapStrategies.get(i);
			return new CompoundSnapToHelper(ss);
		}
		return super.getAdapter(adapter);
	}
}
