package tk.eclipse.plugin.struts.editors.models;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.ui.views.properties.IPropertySource;

import tk.eclipse.plugin.struts.editors.ConnectoinBendpoint;

/**
 * This is a base class of connection models used in the struts-config.xml visual editor.
 */
public abstract class AbstractConnectionModel extends AbstractModel implements IPropertySource {
	
	private AbstractEntityModel source;
	private AbstractEntityModel target;
	private String targetName;
	
	private List bendpoints = new ArrayList();
	public static final String P_BEND_POINT = "__bend_point";
	
	public void attachSource() {
		if (!source.getModelSourceConnections().contains(this)){
			source.addSourceConnection(this);
		}
	}
	
	public void attachTarget() {
		if (!target.getModelTargetConnections().contains(this)){
			target.addTargetConnection(this);
		}
	}
	
	public void detachSource() {
		if(source!=null){
			source.removeSourceConnection(this);
		}
	}
	
	public void detachTarget() {
		if(target!=null){
			target.removeTargetConnection(this);
		}
	}
	
	public AbstractEntityModel getSource() {
		return source;
	}
	
	public AbstractEntityModel getTarget() {
		return target;
	}
	
	public void setSource(AbstractEntityModel model) {
		source = model;
	}
	
	public void setTarget(AbstractEntityModel model) {
		target = model;
	}
	
	public void addBendpoint(int index, ConnectoinBendpoint point) {
		bendpoints.add(index, point);
		firePropertyChange(P_BEND_POINT, null, null);
	}
	
	public List getBendpoints() {
		return bendpoints;
	}
	
	public void removeBendpoint(int index) {
		bendpoints.remove(index);
		firePropertyChange(P_BEND_POINT, null, null);
	}
	
	public void replaceBendpoint(int index, ConnectoinBendpoint point) {
		bendpoints.set(index, point);
		firePropertyChange(P_BEND_POINT, null, null);
	}
	
	public void setTargetName(String targetName){
		this.targetName = targetName;
	}
	
	public String getTargetName(){
		return this.targetName;
	}

}