package tk.eclipse.plugin.struts.editors.models;

import org.eclipse.ui.views.properties.IPropertySource;

import tk.eclipse.plugin.htmleditor.gefutils.ClassSelectPropertyDescriptor;

public class ActionMappingsModel extends AbstractModel implements IPropertySource {
	
	private static final long serialVersionUID = 433183122789379730L;
	
	private String type = "";
	public static final String P_TYPE = "_type";
	
	public ActionMappingsModel(){
		addPropertyDescriptor(P_TYPE, new ClassSelectPropertyDescriptor(P_TYPE,"type"));
	}
	
	public String getType() {
		return type;
	}
	
	public void setType(String type) {
		this.type = type;
		firePropertyChange(P_TYPE,null,type);
	}
	
	public Object getPropertyValue(Object id) {
		if(id.equals(P_TYPE)){
			return getType();
		}
		return super.getPropertyValue(id);
	}
	
	public boolean isPropertySet(Object id) {
		if(id.equals(P_TYPE)){
			return true;
		} else {
			return super.isPropertySet(id);
		}
	}
	
	public void setPropertyValue(Object id, Object value) {
		if(id.equals(P_TYPE)){
			setType((String)value);
		} else {
			super.setPropertyValue(id, value);
		}
	}
	
	public boolean equals(Object obj){
		if(obj instanceof ActionMappingsModel){
			return true;
		}
		return false;
	}
}
