package tk.eclipse.plugin.struts.editors.models;

import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;

import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

import tk.eclipse.plugin.htmleditor.gefutils.ClassSelectPropertyDescriptor;
import tk.eclipse.plugin.htmleditor.gefutils.TextAreaPropertyDescriptor;
import tk.eclipse.plugin.struts.StrutsConfigRefactor;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.properties.BooleanPropertyDescriptor;
import tk.eclipse.plugin.struts.properties.Properties;
import tk.eclipse.plugin.struts.properties.PropertiesPropertyDescriptor;
import tk.eclipse.plugin.struts.properties.ScopePropertyDescriptor;

public class ActionModel extends AbstractEntityModel {
	
	private static final long serialVersionUID = -991501942194985435L;
	
	private String id        = "";
	private String className = "";
    // (MVL) removed -> see DirectForwardModel (connection)
	// private String forward   = "";
	private String path      = "";
	private String type      = "";
	private String scope     = "";
    // (MVL) removed -> see InputModel (connection)
	// private String input     = "";
	private String validate  = "";
	private String name      = "";
	private String parameter = "";
    // (MVL) removed -> see IncludeModel (connection)
	// private String include   = "";
	private String prefix    = "";
	private String suffix    = "";
	private String attribute = "";
	private String roles     = "";
	private String unknown   = "";
	private Properties properties = new Properties();
	
	public static final String P_ID         = "_id";
	public static final String P_CLASSNAME  = "_classname";
	public static final String P_FORWARD    = "_forward";
	public static final String P_PATH       = "_path";
	public static final String P_TYPE       = "_type";
	public static final String P_SCOPE      = "_scope";
	public static final String P_INPUT      = "_input";
	public static final String P_VALIDATE   = "_validate";
	public static final String P_NAME       = "_name";
	public static final String P_PARAMETER  = "_parameter";
	public static final String P_CHILDREN   = "_children";
	public static final String P_INCLUDE    = "_include";
	public static final String P_PREFIX     = "_prefix";
	public static final String P_SUFFIX     = "_suffix";
	public static final String P_ATTRIBUTE  = "_attribute";
	public static final String P_ROLES      = "_roles";
	public static final String P_UNKNOWN    = "_unknown";
	public static final String P_PROPERTIES = "_properties";
	
	public Properties getProperties() {
		return properties;
	}
	
	public void setProperties(Properties properties) {
		this.properties = properties;
		firePropertyChange(P_PROPERTIES,null,properties);
	}
	
	public String getClassName() {
		return className;
	}
	
	public void setClassName(String className) {
		this.className = className;
		firePropertyChange(P_CLASSNAME,null,className);
	}
	
    // (MVL) added
    public DirectForwardModel getForwardConnection() {
        Iterator it = getModelSourceConnections().iterator();
        while (it.hasNext()) {
            AbstractConnectionModel conn = (AbstractConnectionModel) it.next();
            if (conn instanceof DirectForwardModel) {
                return (DirectForwardModel) conn;
            }
        }
        return null;
    }
    
    // (MVL) get from connections
	public String getForward() {
        DirectForwardModel conn = getForwardConnection();
        if (conn != null) {
            AbstractEntityModel target = conn.getTarget();
            if (target instanceof ActionModel){
                return ((ActionModel)target).getPath() + ".do";
            } else if (target instanceof PageModel){
                return ((PageModel)target).getPath();
            }
        }
		return "";
	}
	
    /* (MVL) removed
	public void setForward(String forward) {
		this.forward = forward;
		firePropertyChange(P_FORWARD,null,forward);
	}
    */
	
	public String getId() {
		return id;
	}
	
	public void setId(String id) {
		this.id = id;
		firePropertyChange(P_ID,null,id);
	}
	
	public String getAttribute() {
		return attribute;
	}
	
	public void setAttribute(String attribute) {
		this.attribute = attribute;
		this.firePropertyChange(P_ATTRIBUTE,null,attribute);
	}
	
    // (MVL) added
    public IncludeModel getIncludeConnection() {
        Iterator it = getModelSourceConnections().iterator();
        while (it.hasNext()) {
            AbstractConnectionModel conn = (AbstractConnectionModel) it.next();
            if (conn instanceof IncludeModel) {
                return (IncludeModel) conn;
            }
        }
        return null;
    }
    
    // (MVL) get from connections
    public String getInclude() {
        IncludeModel conn = getIncludeConnection();
        if (conn != null) {
            AbstractEntityModel target = conn.getTarget();
            if (target instanceof ActionModel){
                return ((ActionModel)target).getPath() + ".do";
            } else if (target instanceof PageModel){
                return ((PageModel)target).getPath();
            }
        }
        return "";
    }
    
    /* (MVL) removed
	public void setInclude(String include) {
		this.include = include;
		this.firePropertyChange(P_INCLUDE,null,include);
	}
    */
	
	public String getPrefix() {
		return prefix;
	}
	
	public void setPrefix(String prefix) {
		this.prefix = prefix;
		this.firePropertyChange(P_PREFIX,null,prefix);
	}
	
	public String getRoles() {
		return roles;
	}
	
	public void setRoles(String roles) {
		this.roles = roles;
		this.firePropertyChange(P_ROLES,null,roles);
	}
	
	public String getSuffix() {
		return suffix;
	}
	
	public void setSuffix(String suffix) {
		this.suffix = suffix;
		this.firePropertyChange(P_SUFFIX,null,suffix);
	}
	
	public String getUnknown() {
		return unknown;
	}
	
	public void setUnknown(String unknown) {
		this.unknown = unknown;
		this.firePropertyChange(P_UNKNOWN,null,unknown);
	}
	
	public String getParameter() {
		return parameter;
	}
	
	public void setParameter(String parameter) {
		this.parameter = parameter;
		firePropertyChange(P_PARAMETER,null,parameter);
	}
	
    // (MVL) added
    public InputModel getInputConnection() {
        Iterator it = getModelTargetConnections().iterator();
        while (it.hasNext()) {
            AbstractConnectionModel conn = (AbstractConnectionModel) it.next();
            if (conn instanceof InputModel) {
                return (InputModel) conn;
            }
        }
        return null;
    }
    
    // (MVL) get from connections
	public String getInput() {
        AbstractConnectionModel conn = getInputConnection();
        if (conn != null) {
            AbstractEntityModel source = conn.getSource();
            if (source instanceof ActionModel){
                return ((ActionModel)source).getPath() + ".do";
            } else if (source instanceof PageModel){
                return ((PageModel)source).getPath();
            }
        }
        return "";
	}
	
    /* (MVL) removed 
	public void setInput(String input) {
		this.input = input;
		firePropertyChange(P_INPUT,null,input);
	}
    */
	
	public String getName() {
		return name;
	}
	
	public void setName(String name) {
		this.name = name;
		firePropertyChange(P_NAME,null,name);
	}
	
	public String getPath() {
		return path;
	}
	
	public void setPath(String path) {
		String oldPath = this.path;
		if(!path.equals("/") && !path.startsWith("/")){
			path = "/" + path;
		}
		StrutsConfigRefactor.changePath(getRoot(),this.path+".do",path+".do");
		this.path = path;
		firePropertyChange(P_PATH,oldPath,path);
	}
	
	public String getScope() {
		return scope;
	}
	
	public void setScope(String scope) {
		this.scope = scope;
		firePropertyChange(P_SCOPE,null,scope);
	}
	
	public String getType() {
		return type;
	}
	
	public void setType(String type) {
		this.type = type;
		firePropertyChange(P_TYPE,null,type);
	}
	
	public String getValidate() {
		return validate;
	}
	
	public void setValidate(String validate) {
		this.validate = validate;
		firePropertyChange(P_VALIDATE,null,validate);
	}
	
	public IPropertyDescriptor[] getPropertyDescriptors() {
		
        // (MVL) removed - not needed any more
		//String[] path = getRoot().getForwardPath();
		String[] beanName = getRoot().getBeanNames();
		
		return new IPropertyDescriptor[]{
				new TextPropertyDescriptor(P_ID,"id"),
                // (MVL) changed to read only, as now graphically editable
				// new TextPropertyDescriptor(P_FORWARD,"forward"),
                new PropertyDescriptor(P_FORWARD,"forward"),
				new ClassSelectPropertyDescriptor(P_CLASSNAME,"className"),
				new TextPropertyDescriptor(P_PATH,"path(*)"),
				new ClassSelectPropertyDescriptor(P_TYPE,"type"),
				new ScopePropertyDescriptor(P_SCOPE,"scope"),
                // (MVL) changed to read only, as now graphically editable
				// new ComboBoxPropertyDescriptor(P_INPUT,"input",path),
                new PropertyDescriptor(P_INPUT,"input"),
				new BooleanPropertyDescriptor(P_VALIDATE,"validate"),
				new ComboBoxPropertyDescriptor(P_NAME,"name",beanName),
				new TextPropertyDescriptor(P_PARAMETER,"parameter"),
                // (MVL) changed to read only, as now graphically editable
				// new TextPropertyDescriptor(P_INCLUDE,"include"),
                new PropertyDescriptor(P_INCLUDE,"include"),
				new TextPropertyDescriptor(P_PREFIX,"prefix"),
				new TextPropertyDescriptor(P_SUFFIX,"suffix"),
				new TextPropertyDescriptor(P_ATTRIBUTE,"attribute"),
				new TextPropertyDescriptor(P_ROLES,"roles"),
				new BooleanPropertyDescriptor(P_UNKNOWN,"unknown"),
				new PropertiesPropertyDescriptor(P_PROPERTIES,"properties"),
				new TextAreaPropertyDescriptor(P_COMMENT, "comment")
		};
	}
	
	public Object getPropertyValue(Object id) {
		if(id.equals(P_PATH)){
			return getPath();
		} else if(id.equals(P_TYPE)){
			return getType();
		} else if(id.equals(P_SCOPE)){
			return ScopePropertyDescriptor.convertValue(scope);
		} else if(id.equals(P_INPUT)){
            // (MVL) changed to get the string
			// return new Integer(Util.getIndex(getRoot().getForwardPath(),input));
            return getInput();
		} else if(id.equals(P_VALIDATE)){
			return BooleanPropertyDescriptor.convertValue(validate);
		} else if(id.equals(P_NAME)){
			return new Integer(Util.getIndex(getRoot().getBeanNames(),name));
		} else if(id.equals(P_PARAMETER)){
			return getParameter();
		} else if(id.equals(P_INCLUDE)){
			return getInclude();
		} else if(id.equals(P_PREFIX)){
			return getPrefix();
		} else if(id.equals(P_SUFFIX)){
			return getSuffix();
		} else if(id.equals(P_ATTRIBUTE)){
			return getAttribute();
		} else if(id.equals(P_ROLES)){
			return getRoles();
		} else if(id.equals(P_UNKNOWN)){
			return BooleanPropertyDescriptor.convertValue(unknown);
		} else if(id.equals(P_ID)){
			return getId();
		} else if(id.equals(P_FORWARD)){
			return getForward();
		} else if(id.equals(P_CLASSNAME)){
			return getClassName();
		} else if(id.equals(P_PROPERTIES)){
			return getProperties();
		} else {
			return super.getPropertyValue(id);
		}
	}
	
	public boolean isPropertySet(Object id) {
		if(id.equals(P_PATH) || id.equals(P_TYPE) || id.equals(P_SCOPE) ||
				id.equals(P_INPUT) || id.equals(P_VALIDATE) || id.equals(P_NAME) ||
				id.equals(P_PARAMETER) || id.equals(P_INCLUDE) || id.equals(P_PREFIX) ||
				id.equals(P_SUFFIX) || id.equals(P_ATTRIBUTE) || id.equals(P_ROLES) ||
				id.equals(P_UNKNOWN) || id.equals(P_ID) || id.equals(P_CLASSNAME) ||
				id.equals(P_FORWARD) || id.equals(P_PROPERTIES)){
			return true;
		} else {
			return super.isPropertySet(id);
		}
	}
	
	public void setPropertyValue(Object id, Object value) {
		if(id.equals(P_PATH)){
			setPath((String)value);
		} else if(id.equals(P_TYPE)){
			setType((String)value);
		} else if(id.equals(P_SCOPE)){
			setScope(ScopePropertyDescriptor.convertValue((Integer)value));
        /* (MVL) only editable graphically
		} else if(id.equals(P_INPUT)){
			setInput(getRoot().getForwardPath()[((Integer)value).intValue()]);
        */
		} else if(id.equals(P_VALIDATE)){
			setValidate(BooleanPropertyDescriptor.convertValue((Integer)value));
		} else if(id.equals(P_NAME)){
			setName(getRoot().getBeanNames()[((Integer)value).intValue()]);
		} else if(id.equals(P_PARAMETER)){
			setParameter((String)value);
        /* (MVL) only editable graphically
		} else if(id.equals(P_INCLUDE)){
			setInclude((String)value);
        */
		} else if(id.equals(P_PREFIX)){
			setPrefix((String)value);
		} else if(id.equals(P_SUFFIX)){
			setSuffix((String)value);
		} else if(id.equals(P_ATTRIBUTE)){
			setAttribute((String)value);
		} else if(id.equals(P_ROLES)){
			setRoles((String)value);
		} else if(id.equals(P_UNKNOWN)){
			setUnknown(BooleanPropertyDescriptor.convertValue((Integer)value));
		} else if(id.equals(P_ID)){
			setId((String)value);
		} else if(id.equals(P_CLASSNAME)){
			setClassName((String)value);
        /* (MVL) only editable graphically
		} else if(id.equals(P_FORWARD)){
			setForward((String)value);
        */
		} else if(id.equals(P_PROPERTIES)){
			setProperties((Properties)value);
		} else {
			super.setPropertyValue(id, value);
		}
	}
	
	public boolean equals(Object obj){
		if(obj instanceof ActionModel){
			if(((ActionModel)obj).getPath().equals(getPath())){
				return true;
			}
		}
		return false;
	}
	
	public String toString(){
		StringBuffer sb = new StringBuffer();
		sb.append("action");
		sb.append(" path=" + getPath());
		sb.append(" type=" + getType());
		sb.append(" name=" + getName());
		sb.append(" scope=" + getScope());
		sb.append(" validate=" + getValidate());
		sb.append(" input=" + getInput());
		sb.append(" parameter=" + getParameter());
		return sb.toString();
	}
	
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		super.addPropertyChangeListener(listener);
		List list = getModelSourceConnections();
		for(int i=0;i<list.size();i++){
			((AbstractModel)list.get(i)).addPropertyChangeListener(listener);
		}
	}
	
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		super.removePropertyChangeListener(listener);
		List list = getModelSourceConnections();
		for(int i=0;i<list.size();i++){
			((AbstractModel)list.get(i)).removePropertyChangeListener(listener);
		}
	}
	
	public boolean canSource(AbstractConnectionModel conn) {
		if(conn instanceof ForwardModel || conn instanceof ExceptionModel){
			return true;
        // (MVL) added:
        } else if (conn instanceof DirectForwardModel) {
            AbstractConnectionModel forwardConn = getForwardConnection();
            AbstractConnectionModel includeConn = getIncludeConnection();
            return (includeConn == null) && (forwardConn == null || forwardConn == conn);
        } else if (conn instanceof IncludeModel) {
            AbstractConnectionModel forwardConn = getForwardConnection();
            AbstractConnectionModel includeConn = getIncludeConnection();
            return (forwardConn == null) && (includeConn == null || includeConn == conn);
        } else if (conn instanceof InputModel) {
            return true;
        }
		return false;
	}
	
	public boolean canTarget(AbstractConnectionModel conn) {
		if(conn instanceof ForwardModel || conn instanceof ExceptionModel){
			return true;
            // (MVL) added:
        } else if (conn instanceof DirectForwardModel) {
            return true;
        } else if (conn instanceof IncludeModel) {
            return true;
        } else if (conn instanceof InputModel) {
            AbstractConnectionModel inputConn = getInputConnection();
            return (inputConn == null || inputConn == conn);
        }
		return false;
	}
}
