package tk.eclipse.plugin.struts.editors.models;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

import tk.eclipse.plugin.htmleditor.gefutils.ClassSelectPropertyDescriptor;
import tk.eclipse.plugin.htmleditor.gefutils.TextAreaPropertyDescriptor;
import tk.eclipse.plugin.struts.properties.BooleanPropertyDescriptor;
import tk.eclipse.plugin.struts.properties.Properties;
import tk.eclipse.plugin.struts.properties.PropertiesPropertyDescriptor;

public class ControllerModel extends AbstractModel implements IPropertySource {
	
	private static final long serialVersionUID = -8650883837183301571L;
	
	private String  id             = "";
	private String  bufferSize     = "";
	private String  className      = "";
	private String  contentType    = "";
	private String  debug          = "";
	private String  forwardPattern = "";
	private String  inputForward   = "";
	private String  locale         = "";
	private String  maxFileSize    = "";
	private String  memFileSize    = "";
	private String  multipartClass = "";
	private String  nocache        = "";
	private String  pagePattern    = "";
	private String  processorClass = "";
	private String  tempDir        = "";
	private Properties properties = new Properties();
	
	public static final String P_ID = "_id";
	public static final String P_BUFFER_SIZE = "_buffer_size";
	public static final String P_CLASS_NAME = "_class_name";
	public static final String P_CONTENT_TYPE = "_content_type";
	public static final String P_DEBUG = "_debug";
	public static final String P_FORWARD_PATTERN = "_forward_pattern";
	public static final String P_INPUT_FORWARD = "_input_pattern";
	public static final String P_LOCALE = "_locale";
	public static final String P_MAX_FILE_SIZE = "_max_file_size";
	public static final String P_MEM_FILE_SIZE = "_mem_file_size";
	public static final String P_MULTIPART_CLASS = "_multipart_class";
	public static final String P_NOCACHE = "_nocache";
	public static final String P_PAGE_PATTERN = "_page_pattern";
	public static final String P_PROCESSOR_CLASS = "_processor_class";
	public static final String P_TEMP_DIR = "_temp_dir";
	public static final String P_PROPERTIES = "_properties";
	
	public Properties getProperties() {
		return properties;
	}
	
	public void setProperties(Properties properties) {
		this.properties = properties;
		firePropertyChange(P_PROPERTIES,null,properties);
	}
	
	public String getDebug() {
		return debug;
	}
	
	public void setDebug(String debug) {
		this.debug = debug;
		firePropertyChange(P_DEBUG,null,debug);
	}
	
	public String getId() {
		return id;
	}
	
	public void setId(String id) {
		this.id = id;
		firePropertyChange(P_ID,null,id);
	}
	
	public String getMemFileSize() {
		return memFileSize;
	}
	
	public void setMemFileSize(String memFileSize) {
		this.memFileSize = memFileSize;
		firePropertyChange(P_MEM_FILE_SIZE,null,memFileSize);
	}
	
	public String getBufferSize() {
		return bufferSize;
	}

	public void setBufferSize(String bufferSize) {
		this.bufferSize = bufferSize;
		firePropertyChange(P_BUFFER_SIZE,null,bufferSize);
	}

	public String getClassName() {
		return className;
	}

	public void setClassName(String className) {
		this.className = className;
		firePropertyChange(P_CLASS_NAME,null,className);
	}
	
	public String getContentType() {
		return contentType;
	}

	public void setContentType(String contentType) {
		this.contentType = contentType;
		firePropertyChange(P_CONTENT_TYPE,null,contentType);
	}
	
	public String getForwardPattern() {
		return forwardPattern;
	}
	
	public void setForwardPattern(String forwardPattern) {
		this.forwardPattern = forwardPattern;
		firePropertyChange(P_FORWARD_PATTERN,null,forwardPattern);
	}
	
	public String getInputForward() {
		return inputForward;
	}
	
	public void setInputForward(String inputForward) {
		this.inputForward = inputForward;
		firePropertyChange(P_INPUT_FORWARD,null,inputForward);
	}
	
	public String getLocale() {
		return locale;
	}
	
	public void setLocale(String locale) {
		this.locale = locale;
		firePropertyChange(P_LOCALE,null,locale);
	}
	
	public String getMaxFileSize() {
		return maxFileSize;
	}
	
	public void setMaxFileSize(String maxFileSize) {
		this.maxFileSize = maxFileSize;
		firePropertyChange(P_MAX_FILE_SIZE,null,maxFileSize);
	}
	
	public String getMultipartClass() {
		return multipartClass;
	}
	
	public void setMultipartClass(String multipartClass) {
		this.multipartClass = multipartClass;
		firePropertyChange(P_MULTIPART_CLASS,null,multipartClass);
	}
	
	public String getNocache() {
		return nocache;
	}
	
	public void setNocache(String nocache) {
		this.nocache = nocache;
		firePropertyChange(P_NOCACHE,null,nocache);
	}
	
	public String getPagePattern() {
		return pagePattern;
	}
	
	public void setPagePattern(String pagePattern) {
		this.pagePattern = pagePattern;
		firePropertyChange(P_PAGE_PATTERN,null,pagePattern);
	}
	
	public String getProcessorClass() {
		return processorClass;
	}
	
	public void setProcessorClass(String processorClass) {
		this.processorClass = processorClass;
		firePropertyChange(P_PROCESSOR_CLASS,null,processorClass);
	}
	
	public String getTempDir() {
		return tempDir;
	}
	
	public void setTempDir(String tempDir) {
		this.tempDir = tempDir;
		firePropertyChange(P_TEMP_DIR,null,tempDir);
	}
	
	public Object getEditableValue() {
		return this;
	}
	
	public IPropertyDescriptor[] getPropertyDescriptors() {
		return new IPropertyDescriptor[]{
			new TextPropertyDescriptor(P_BUFFER_SIZE,"bufferSize"),
			new ClassSelectPropertyDescriptor(P_CLASS_NAME,"className"),
			new TextPropertyDescriptor(P_CONTENT_TYPE,"contentType"),
			new TextPropertyDescriptor(P_FORWARD_PATTERN,"forwardPattern"),
			new TextPropertyDescriptor(P_INPUT_FORWARD,"inputForward"),
			new BooleanPropertyDescriptor(P_LOCALE,"locale"),
			new TextPropertyDescriptor(P_MAX_FILE_SIZE,"maxFileSize"),
			new ClassSelectPropertyDescriptor(P_MULTIPART_CLASS,"multipartClass"),
			new BooleanPropertyDescriptor(P_NOCACHE,"nocache"),
			new TextPropertyDescriptor(P_PAGE_PATTERN,"pagePattern"),
			new ClassSelectPropertyDescriptor(P_PROCESSOR_CLASS,"processorClass"),
			new TextPropertyDescriptor(P_TEMP_DIR,"tempDir"),
			new TextPropertyDescriptor(P_ID,"id"),
			new TextPropertyDescriptor(P_DEBUG,"debug"),
			new TextPropertyDescriptor(P_MEM_FILE_SIZE,"memFileSize"),
			new PropertiesPropertyDescriptor(P_PROPERTIES,"properties"),
			new TextAreaPropertyDescriptor(P_COMMENT, "comment")
		};
	}
	
	public Object getPropertyValue(Object id) {
		if(id.equals(P_BUFFER_SIZE)){
			return getBufferSize();
		} else if(id.equals(P_CLASS_NAME)){
			return getClassName();
		} else if(id.equals(P_CONTENT_TYPE)){
			return getContentType();
		} else if(id.equals(P_FORWARD_PATTERN)){
			return getForwardPattern();
		} else if(id.equals(P_INPUT_FORWARD)){
			return getInputForward();
		} else if(id.equals(P_LOCALE)){
			return BooleanPropertyDescriptor.convertValue(locale);
		} else if(id.equals(P_MAX_FILE_SIZE)){
			return getMaxFileSize();
		} else if(id.equals(P_MULTIPART_CLASS)){
			return getMultipartClass();
		} else if(id.equals(P_NOCACHE)){
			return BooleanPropertyDescriptor.convertValue(nocache);
		} else if(id.equals(P_PAGE_PATTERN)){
			return getPagePattern();
		} else if(id.equals(P_PROCESSOR_CLASS)){
			return getProcessorClass();
		} else if(id.equals(P_TEMP_DIR)){
			return getTempDir();
		} else if(id.equals(P_ID)){
			return getId();
		} else if(id.equals(P_MEM_FILE_SIZE)){
			return getMemFileSize();
		} else if(id.equals(P_DEBUG)){
			return getDebug();
		} else if(id.equals(P_PROPERTIES)){
			return getProperties();
		} else {
			return super.getPropertyValue(id);
		}
	}
	
	public boolean isPropertySet(Object id) {
		if(id.equals(P_BUFFER_SIZE)||id.equals(P_CLASS_NAME)||id.equals(P_CONTENT_TYPE)||
		   id.equals(P_FORWARD_PATTERN)||id.equals(P_INPUT_FORWARD)||id.equals(P_LOCALE)||
		   id.equals(P_MAX_FILE_SIZE)||id.equals(P_MULTIPART_CLASS)||id.equals(P_NOCACHE)||
		   id.equals(P_PAGE_PATTERN)||id.equals(P_PROCESSOR_CLASS)||id.equals(P_TEMP_DIR)||
		   id.equals(P_ID)||id.equals(P_MEM_FILE_SIZE)||id.equals(P_DEBUG)||
		   id.equals(P_PROPERTIES)){
			return true;
		} else {
			return super.isPropertySet(id);
		}
	}
	
	public void setPropertyValue(Object id, Object value) {
		if(id.equals(P_BUFFER_SIZE)){
			setBufferSize((String)value);
		} else if(id.equals(P_CLASS_NAME)){
			setClassName((String)value);
		} else if(id.equals(P_CONTENT_TYPE)){
			setContentType((String)value);
		} else if(id.equals(P_FORWARD_PATTERN)){
			setForwardPattern((String)value);
		} else if(id.equals(P_INPUT_FORWARD)){
			setInputForward((String)value);
		} else if(id.equals(P_LOCALE)){
			setLocale(BooleanPropertyDescriptor.convertValue((Integer)value));
		} else if(id.equals(P_MAX_FILE_SIZE)){
			setMaxFileSize((String)value);
		} else if(id.equals(P_MULTIPART_CLASS)){
			setMultipartClass((String)value);
		} else if(id.equals(P_NOCACHE)){
			setNocache(BooleanPropertyDescriptor.convertValue((Integer)value));
		} else if(id.equals(P_PAGE_PATTERN)){
			setPagePattern((String)value);
		} else if(id.equals(P_PROCESSOR_CLASS)){
			setProcessorClass((String)value);
		} else if(id.equals(P_TEMP_DIR)){
			setTempDir((String)value);
		} else if(id.equals(P_ID)){
			setId((String)value);
		} else if(id.equals(P_MEM_FILE_SIZE)){
			setMemFileSize((String)value);
		} else if(id.equals(P_DEBUG)){
			setDebug((String)value);
		} else if(id.equals(P_PROPERTIES)){
			setProperties((Properties)value);
		} else {
			super.setPropertyValue(id, value);
		}
	}
	
	public boolean equals(Object obj){
		if(obj instanceof ControllerModel){
			return true;
		}
		return false;
	}
}
