package tk.eclipse.plugin.struts.editors.models;

import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class DataSourcesModel extends AbstractModel implements IPropertySource {
	
	private static final long serialVersionUID = -6067208162091381056L;
	
	private String id = "";
	public static final String P_ID = "_id";

	public DataSourcesModel(){
		addPropertyDescriptor(P_ID, new TextPropertyDescriptor(P_ID,"id"));
	}
	
	public String getId() {
		return id;
	}
	
	public void setId(String id) {
		this.id = id;
		firePropertyChange(P_ID,null,id);
	}
	
	public Object getPropertyValue(Object id) {
		if(id.equals(P_ID)){
			return getId();
		}
		return super.getPropertyValue(id);
	}
	
	public void setPropertyValue(Object id, Object value) {
		if(id.equals(P_ID)){
			setId((String)value);
		} else {
			super.setPropertyValue(id, value);
		}
	}
	
	public boolean equals(Object obj){
		if(obj instanceof DataSourcesModel){
			return true;
		}
		return false;
	}
}
