package tk.eclipse.plugin.struts.editors.models;

import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

import tk.eclipse.plugin.htmleditor.gefutils.ClassSelectPropertyDescriptor;
import tk.eclipse.plugin.struts.properties.Properties;
import tk.eclipse.plugin.struts.properties.PropertiesPropertyDescriptor;
import tk.eclipse.plugin.struts.properties.ScopePropertyDescriptor;

/**
 * @author naoki
 */
public class ExceptionModel extends AbstractConnectionModel {
	
	private static final long serialVersionUID = -4870358313820352480L;
	
	private String id        = "";
	private String bundle    = "";
	private String className = "";
	private String handler   = "";
	private String key       = "";
	private String scope     = "";
	private String type      = "";
	private Properties properties = new Properties();
	
	public static final String P_ID         = "_id";
	public static final String P_BUNDLE     = "_bundle";
	public static final String P_TYPE       = "_type";
	public static final String P_PATH       = "_path";
	public static final String P_KEY        = "_key";
	public static final String P_HANDLER    = "_handler";
	public static final String P_SCOPE      = "_scope";
	public static final String P_CLASS_NAME = "_class_name";
	public static final String P_PROPERTIES = "_properties";
	
	public ExceptionModel(){
		addPropertyDescriptor(P_TYPE, new ClassSelectPropertyDescriptor(P_TYPE,"type(*)"));
		addPropertyDescriptor(P_KEY, new TextPropertyDescriptor(P_KEY,"key(*)"));
		addPropertyDescriptor(P_PATH, new PropertyDescriptor(P_PATH,"path"));
		addPropertyDescriptor(P_HANDLER, new ClassSelectPropertyDescriptor(P_HANDLER,"handler"));
		addPropertyDescriptor(P_CLASS_NAME, new ClassSelectPropertyDescriptor(P_CLASS_NAME,"className"));
		addPropertyDescriptor(P_SCOPE, new ScopePropertyDescriptor(P_SCOPE,"scope"));
		addPropertyDescriptor(P_ID, new TextPropertyDescriptor(P_ID,"id"));
		addPropertyDescriptor(P_BUNDLE, new TextPropertyDescriptor(P_BUNDLE,"bundle"));
		addPropertyDescriptor(P_PROPERTIES, new PropertiesPropertyDescriptor(P_PROPERTIES,"properties"));
	}
	
	public String getBundle() {
		return bundle;
	}
	
	public void setBundle(String bundle) {
		this.bundle = bundle;
		firePropertyChange(P_BUNDLE,null,bundle);
	}
	
	public String getId() {
		return id;
	}
	
	public void setId(String id) {
		this.id = id;
		firePropertyChange(P_ID,null,id);
	}
	
	public Properties getProperties() {
		return properties;
	}
	
	public void setProperties(Properties properties) {
		this.properties = properties;
		firePropertyChange(P_PROPERTIES,null,properties);
	}
	
	public String getClassName() {
		return className;
	}
	
	public void setClassName(String className) {
		this.className = className;
		firePropertyChange(P_CLASS_NAME,null,className);
	}
	
	public String getHandler() {
		return handler;
	}
	
	public void setHandler(String handler) {
		this.handler = handler;
		firePropertyChange(P_HANDLER,null,handler);
	}
	
	public String getScope() {
		return scope;
	}
	
	public void setScope(String scope) {
		this.scope = scope;
		firePropertyChange(P_SCOPE,null,scope);
	}
	
	public void setType(String type){
		String oldValue = this.type;
		this.type = type;
		firePropertyChange(P_TYPE,oldValue,type);
	}
	
	public String getType(){
		return this.type;
	}
	
	public String getKey() {
		return key;
	}
	
	public void setKey(String key) {
		this.key = key;
		firePropertyChange(P_KEY,null,key);
	}
	
	public Object getPropertyValue(Object id) {
		if(id.equals(P_TYPE)){
			return getType();
		} else if(id.equals(P_PATH)){
			AbstractEntityModel model = getTarget();
			if(model instanceof ActionModel){
				return ((ActionModel)model).getPath() + ".do";
			} else if(model instanceof PageModel){
				return ((PageModel)model).getPath();
			}
		} else if(id.equals(P_KEY)){
			return getKey();
		} else if(id.equals(P_HANDLER)){
			return getHandler();
		} else if(id.equals(P_CLASS_NAME)){
			return getClassName();
		} else if(id.equals(P_SCOPE)){
			return ScopePropertyDescriptor.convertValue(scope);
		} else if(id.equals(P_ID)){
			return getId();
		} else if(id.equals(P_BUNDLE)){
			return getBundle();
		} else if(id.equals(P_PROPERTIES)){
			return getProperties();
		}
		return super.getPropertyValue(id);
	}
	
	public void setPropertyValue(Object id, Object value) {
		if(id.equals(P_TYPE)){
			this.setType((String)value);
		} else if(id.equals(P_KEY)){
			this.setKey((String)value);
		} else if(id.equals(P_SCOPE)){
			setScope(ScopePropertyDescriptor.convertValue((Integer)value));
		} else if(id.equals(P_HANDLER)){
			setHandler((String)value);
		} else if(id.equals(P_CLASS_NAME)){
			setClassName((String)value);
		} else if(id.equals(P_ID)){
			setId((String)value);
		} else if(id.equals(P_BUNDLE)){
			setBundle((String)value);
		} else if(id.equals(P_PROPERTIES)){
			setProperties((Properties)value);
		} else {
			super.setPropertyValue(id, value);
		}
	}
	
	public boolean equals(Object obj){
		if(obj instanceof ExceptionModel){
			ExceptionModel model = (ExceptionModel)obj;
			if(model.getSource().equals(getSource()) && model.getType().equals(getType())){
				return true;
			}
		}
		return false;
	}
	
	public String getFromPath(){
		AbstractEntityModel model = getSource();
		if(model instanceof ActionModel){
			return ((ActionModel)model).getPath();
		} else if(model instanceof PageModel){
			return ((PageModel)model).getPath();
		}
		return null;
	}
	
	public String toString(){
		StringBuffer sb = new StringBuffer();
		sb.append("  exception");
		sb.append(" type=" + getType());
		sb.append(" key="+getKey());
		return sb.toString();
	}
}
