package tk.eclipse.plugin.struts.editors.models;

import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

import tk.eclipse.plugin.htmleditor.gefutils.ClassSelectPropertyDescriptor;
import tk.eclipse.plugin.struts.StrutsConfigRefactor;
import tk.eclipse.plugin.struts.properties.BooleanPropertyDescriptor;
import tk.eclipse.plugin.struts.properties.FormProperties;
import tk.eclipse.plugin.struts.properties.FormPropertiesPropertyDescriptor;

public class FormBeanModel extends AbstractModel implements IPropertySource {
	
	private static final long serialVersionUID = 4007194809338707752L;
	
	private String name = "";
	private String type = "";
	private String className = "";
	private String dynamic = "";
	private String id = "";
	
	private FormProperties formProperties = new FormProperties();
	private RootModel root;
	
	public static final String P_NAME = "_name";
	public static final String P_TYPE = "_type";
	public static final String P_CLASS_NAME = "_class_name";
	public static final String P_DYNAMIC = "_dynamic";
	public static final String P_ID = "_id";
	public static final String P_PROPERTIES = "_form_properties";
	
	public FormBeanModel(){
		addPropertyDescriptor(P_TYPE, new ClassSelectPropertyDescriptor(P_TYPE,"type(*)"));
		addPropertyDescriptor(P_NAME, new TextPropertyDescriptor(P_NAME,"name(*)"));
		addPropertyDescriptor(P_PROPERTIES, new FormPropertiesPropertyDescriptor(P_PROPERTIES,"form-properties"));
		addPropertyDescriptor(P_CLASS_NAME, new ClassSelectPropertyDescriptor(P_CLASS_NAME,"className"));
		addPropertyDescriptor(P_ID, new TextPropertyDescriptor(P_ID,"id"));
		addPropertyDescriptor(P_DYNAMIC, new BooleanPropertyDescriptor(P_DYNAMIC,"dynamic"));
	}
	
	public void setRoot(RootModel root){
		this.root = root;
	}
	
	public RootModel getRoot(){
		return this.root;
	}
	
	public String getClassName() {
		return className;
	}
	
	public void setClassName(String className) {
		this.className = className;
		firePropertyChange(P_CLASS_NAME,null,className);
	}
	
	public String getDynamic() {
		return dynamic;
	}
	
	public void setDynamic(String dynamic) {
		this.dynamic = dynamic;
		firePropertyChange(P_DYNAMIC,null,dynamic);
	}
	
	public String getId() {
		return id;
	}
	
	public void setId(String id) {
		this.id = id;
		firePropertyChange(P_ID,null,id);
	}
	
	public String getName() {
		return name;
	}
	
	public void setName(String name) {
		String oldName = this.name;
		StrutsConfigRefactor.changeFormName(getRoot(),this.name,name);
		this.name = name;
		firePropertyChange(P_NAME,oldName,name);
	}
	
	public String getType() {
		return type;
	}
	
	public void setType(String type) {
		this.type = type;
		firePropertyChange(P_TYPE,null,type);
	}
	
	public Object getPropertyValue(Object id) {
		if(id.equals(P_TYPE)){
			return getType();
		} else if(id.equals(P_NAME)){
			return getName();
		} else if(id.equals(P_PROPERTIES)){
			return getFormProperties();
		} else if(id.equals(P_ID)){
			return getId();
		} else if(id.equals(P_CLASS_NAME)){
			return getClassName();
		} else if(id.equals(P_DYNAMIC)){
			return BooleanPropertyDescriptor.convertValue(dynamic);
		}
		return super.getPropertyValue(id);
	}
	
	public void setPropertyValue(Object id, Object value) {
		if(id.equals(P_TYPE)){
			setType((String)value);
		} else if(id.equals(P_NAME)){
			setName((String)value);
		} else if(id.equals(P_PROPERTIES)){
			setFormProperties((FormProperties)value);
		} else if(id.equals(P_ID)){
			setId((String)value);
		} else if(id.equals(P_CLASS_NAME)){
			setClassName((String)value);
		} else if(id.equals(P_DYNAMIC)){
			setDynamic(BooleanPropertyDescriptor.convertValue((Integer)value));
		} else {
			super.setPropertyValue(id, value);
		}
	}
	
	public boolean equals(Object obj){
		if(obj instanceof FormBeanModel){
			if(((FormBeanModel)obj).getName().equals(getName())){
				return true;
			}
		}
		return false;
	}
	
	public String toString(){
		StringBuffer sb = new StringBuffer();
		sb.append("bean");
		sb.append(" name=" + getName());
		sb.append(" type=" + getType());
		return sb.toString();
	}
	
	public FormProperties getFormProperties() {
		return formProperties;
	}
	
	public void setFormProperties(FormProperties formProperties) {
		this.formProperties = formProperties;
		firePropertyChange(P_PROPERTIES,null,formProperties);
	}
}
