package tk.eclipse.plugin.struts.editors.models;

import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

import tk.eclipse.plugin.htmleditor.gefutils.ClassSelectPropertyDescriptor;

/**
 * @author takezoe
 */
public class FormBeansModel extends AbstractModel implements IPropertySource {

	private static final long serialVersionUID = -4914228486427477997L;
	
	private String id = "";
	private String type = "";
	
	public static final String P_ID = "_id";
	public static final String P_TYPE = "_type";
	
	public FormBeansModel(){
		addPropertyDescriptor(P_ID, new TextPropertyDescriptor(P_ID,"id"));
		addPropertyDescriptor(P_TYPE, new ClassSelectPropertyDescriptor(P_TYPE,"type"));
	}
	
	public String getId() {
		return id;
	}
	
	public void setId(String id) {
		this.id = id;
		firePropertyChange(P_ID,null,id);
	}
	
	public String getType() {
		return type;
	}
	
	public void setType(String type) {
		this.type = type;
		firePropertyChange(P_TYPE,null,type);
	}
	
	public Object getPropertyValue(Object id) {
		if(id.equals(P_ID)){
			return getId();
		} else if(id.equals(P_TYPE)){
			return getType();
		}
		return super.getPropertyValue(id);
	}
	
	public void setPropertyValue(Object id, Object value) {
		if(id.equals(P_ID)){
			setId((String)value);
		} else if(id.equals(P_TYPE)){
			setType((String)value);
		} else {
			super.setPropertyValue(id, value);
		}
	}
	
	public boolean equals(Object obj){
		if(obj instanceof FormBeansModel){
			return true;
		}
		return false;
	}
}
