package tk.eclipse.plugin.struts.editors.models;

import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

import tk.eclipse.plugin.htmleditor.gefutils.ClassSelectPropertyDescriptor;
import tk.eclipse.plugin.struts.properties.BooleanPropertyDescriptor;
import tk.eclipse.plugin.struts.properties.Properties;
import tk.eclipse.plugin.struts.properties.PropertiesPropertyDescriptor;

public class ForwardModel extends AbstractConnectionModel {
	
	private static final long serialVersionUID = 6299802366602130760L;
	
	private String id              = "";
	private String className       = "";
	private String contextRelative = "";
	private String name            = "";
	private String redirect        = "";
	private Properties properties = new Properties();
	
	public static final String P_ID              = "_id";
	public static final String P_CLASSNAME       = "_class_name";
	public static final String P_CONTEXTRELATIVE = "_context_relative";
	public static final String P_NAME            = "_name";
	public static final String P_PATH            = "_path";
	public static final String P_REDIRECT        = "_redirect";
	public static final String P_PROPERTIES      = "_properties";
	
	public ForwardModel(){
		addPropertyDescriptor(P_NAME, new TextPropertyDescriptor(P_NAME,"name(*)"));
		addPropertyDescriptor(P_PATH, new PropertyDescriptor(P_PATH,"path(*)"));
		addPropertyDescriptor(P_ID, new TextPropertyDescriptor(P_ID,"id"));
		addPropertyDescriptor(P_CLASSNAME, new ClassSelectPropertyDescriptor(P_CLASSNAME,"className"));
		addPropertyDescriptor(P_CONTEXTRELATIVE, new BooleanPropertyDescriptor(P_CONTEXTRELATIVE,"contextRelative"));
		addPropertyDescriptor(P_REDIRECT, new BooleanPropertyDescriptor(P_REDIRECT,"redirect"));
		addPropertyDescriptor(P_PROPERTIES, new PropertiesPropertyDescriptor(P_PROPERTIES,"properties"));
	}
	
	public String getClassName() {
		return className;
	}
	
	public void setClassName(String className) {
		this.className = className;
		firePropertyChange(P_CLASSNAME,null,className);
	}
	
	public String getContextRelative() {
		return contextRelative;
	}
	
	public void setContextRelative(String contextRelative) {
		this.contextRelative = contextRelative;
		firePropertyChange(P_CONTEXTRELATIVE,null,contextRelative);
	}
	
	public String getId() {
		return id;
	}
	
	public void setId(String id) {
		this.id = id;
		firePropertyChange(P_ID,null,id);
	}
	
	public Properties getProperties() {
		return properties;
	}
	
	public void setProperties(Properties properties) {
		this.properties = properties;
		firePropertyChange(P_PROPERTIES,null,properties);
	}
	
	public String getRedirect() {
		return redirect;
	}
	
	public void setRedirect(String redirect) {
		this.redirect = redirect;
		firePropertyChange(P_REDIRECT,null,redirect);
	}
	
	public void setName(String name){
		String oldValue = this.name;
		this.name = name;
		firePropertyChange(P_NAME,oldValue,name);
	}
	
	public String getName(){
		return this.name;
	}
	
	public Object getPropertyValue(Object id) {
		if(id.equals(P_NAME)){
			return getName();
		} else if(id.equals(P_PATH)){
			if(getTargetName()!=null){
				return getTargetName();
			}
			AbstractEntityModel model = getTarget();
			if(model instanceof ActionModel){
				return ((ActionModel)model).getPath() + ".do";
			} else if(model instanceof PageModel){
				return ((PageModel)model).getPath();
			}
		} else if(id.equals(P_ID)){
			return getId();
		} else if(id.equals(P_CLASSNAME)){
			return getClassName();
		} else if(id.equals(P_CONTEXTRELATIVE)){
			return BooleanPropertyDescriptor.convertValue(contextRelative);
		} else if(id.equals(P_PROPERTIES)){
			return getProperties();
		} else if(id.equals(P_REDIRECT)){
			return BooleanPropertyDescriptor.convertValue(redirect);
		}
		return super.getPropertyValue(id);
	}
	
	public void setPropertyValue(Object id, Object value) {
		if(id.equals(P_NAME)){
			this.setName((String)value);
		} else if(id.equals(P_ID)){
			this.setId((String)value);
		} else if(id.equals(P_CLASSNAME)){
			this.setClassName((String)value);
		} else if(id.equals(P_CONTEXTRELATIVE)){
			this.setContextRelative(BooleanPropertyDescriptor.convertValue((Integer)value));
		} else if(id.equals(P_REDIRECT)){
			this.setRedirect(BooleanPropertyDescriptor.convertValue((Integer)value));
		} else if(id.equals(P_PROPERTIES)){
			this.setProperties((Properties)value);
		} else {
			super.setPropertyValue(id, value);
		}
	}
	
	public boolean equals(Object obj){
		if(obj instanceof ForwardModel){
			ForwardModel model = (ForwardModel)obj;
			if(model.getSource().equals(getSource()) && model.getName().equals(getName())){
				return true;
			}
		}
		return false;
	}
	
	public String getFromPath(){
		AbstractEntityModel model = getSource();
		if(model instanceof ActionModel){
			return ((ActionModel)model).getPath();
		} else if(model instanceof PageModel){
			return ((PageModel)model).getPath();
		}
		return null;
	}
	
	public String toString(){
		StringBuffer sb = new StringBuffer();
		sb.append("  forward");
		sb.append(" name=" + getName());
		return sb.toString();
	}
}
