package tk.eclipse.plugin.struts.editors.models;

import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/**
 * @author Naoki Takezoe
 */
public class GlobalExceptionsModel extends AbstractModel implements IPropertySource {
	
	private static final long serialVersionUID = 6229782669584735011L;

	private String id = "";
	
	public static final String P_ID = "_id";
	
	public GlobalExceptionsModel(){
		addPropertyDescriptor(P_ID, new TextPropertyDescriptor(P_ID, "id"));
	}
	
	public String getId() {
		return id;
	}
	
	public void setId(String id) {
		this.id = id;
		firePropertyChange(P_ID,null,id);
	}
	
	public Object getPropertyValue(Object id) {
		if(id.equals(P_ID)){
			return getId();
		}
		return super.getPropertyValue(id);
	}
	
	public void setPropertyValue(Object id, Object value) {
		if(id.equals(P_ID)){
			setId((String)value);
		} else {
			super.setPropertyValue(id, value);
		}
	}
	
	public boolean equals(Object obj){
		if(obj instanceof GlobalExceptionsModel){
			return true;
		}
		return false;
	}
}
