package tk.eclipse.plugin.struts.editors.models;

import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

import tk.eclipse.plugin.htmleditor.gefutils.ClassSelectPropertyDescriptor;

/**
 * @author Naoki Takezoe
 */
public class GlobalForwardsModel extends AbstractModel implements IPropertySource {
	
	private static final long serialVersionUID = 2582197725566974042L;
	
	private String type = "";
	private String id = "";
	public static final String P_TYPE = "_type";
	public static final String P_ID = "_id";
	
	public GlobalForwardsModel(){
		addPropertyDescriptor(P_TYPE, new ClassSelectPropertyDescriptor(P_TYPE,"type"));
		addPropertyDescriptor(P_ID, new TextPropertyDescriptor(P_ID,"id"));
		
	}
	
	public String getId() {
		return id;
	}
	
	public void setId(String id) {
		this.id = id;
		firePropertyChange(P_ID,null,id);
	}
	
	public String getType() {
		return type;
	}
	
	public void setType(String type) {
		this.type = type;
		firePropertyChange(P_TYPE,null,type);
	}
	
	public Object getPropertyValue(Object id) {
		if(id.equals(P_TYPE)){
			return getType();
		} else if(id.equals(P_ID)){
			return getId();
		}
		return super.getPropertyValue(id);
	}
	
	public void setPropertyValue(Object id, Object value) {
		if(id.equals(P_TYPE)){
			setType((String)value);
		} else if(id.equals(P_ID)){
			setId((String)value);
		} else {
			super.setPropertyValue(id, value);
		}
	}
	
	public boolean equals(Object obj){
		if(obj instanceof GlobalForwardsModel){
			return true;
		}
		return false;
	}
}
