package tk.eclipse.plugin.struts.editors.models;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

import tk.eclipse.plugin.htmleditor.gefutils.ClassSelectPropertyDescriptor;
import tk.eclipse.plugin.struts.properties.BooleanPropertyDescriptor;
import tk.eclipse.plugin.struts.properties.Properties;
import tk.eclipse.plugin.struts.properties.PropertiesPropertyDescriptor;

public class MessageResourcesModel extends AbstractModel implements IPropertySource {
	
	private static final long serialVersionUID = -1457436921253247477L;
	
	private String id = "";
	private String parameter = "";
	private String key = "";
	private String className = "";
	private String factory = "";
	private String nullVal = "";
	private Properties properties = new Properties();
	
	public static final String P_ID = "_id";
	public static final String P_PARAMETER = "_parameter";
	public static final String P_KEY = "_key";
	public static final String P_CLASSNAME = "_class_name";
	public static final String P_FACTORY = "_factory";
	public static final String P_NULL = "_null";
	public static final String P_PROPERTIES = "_properties";
	
	public String getClassName() {
		return className;
	}
	
	public void setClassName(String className) {
		this.className = className;
		firePropertyChange(P_CLASSNAME,null,className);
	}
	
	public String getFactory() {
		return factory;
	}
	
	public void setFactory(String factory) {
		this.factory = factory;
		firePropertyChange(P_FACTORY,null,factory);
	}
	
	public String getId() {
		return id;
	}
	
	public void setId(String id) {
		this.id = id;
		firePropertyChange(P_ID,null,id);
	}
	
	public String getNull() {
		return nullVal;
	}
	
	public void setNull(String nullVal) {
		this.nullVal = nullVal;
		firePropertyChange(P_NULL,null,nullVal);
	}
	
	public Properties getProperties() {
		return properties;
	}
	
	public void setProperties(Properties properties) {
		this.properties = properties;
		firePropertyChange(P_PROPERTIES,null,properties);
	}
	
	public String getKey() {
		return key;
	}
	
	public void setKey(String key) {
		this.key = key;
		firePropertyChange(P_KEY,null,key);
	}
	
	public String getParameter() {
		return parameter;
	}
	
	public void setParameter(String parameter) {
		this.parameter = parameter;
		firePropertyChange(P_PARAMETER,null,parameter);
	}
	
	public Object getEditableValue() {
		return this;
	}

	public IPropertyDescriptor[] getPropertyDescriptors() {
		return new IPropertyDescriptor[]{
			new TextPropertyDescriptor(P_ID,"id"),
			new TextPropertyDescriptor(P_PARAMETER,"parameter(*)"),
			new TextPropertyDescriptor(P_KEY,"key"),
			new ClassSelectPropertyDescriptor(P_CLASSNAME,"className"),
			new ClassSelectPropertyDescriptor(P_FACTORY,"factory"),
			new BooleanPropertyDescriptor(P_NULL,"null"),
			new PropertiesPropertyDescriptor(P_PROPERTIES,"properties"),
		};
	}

	public Object getPropertyValue(Object id) {
		if(id.equals(P_PARAMETER)){
			return getParameter();
		} else if(id.equals(P_KEY)){
			return getKey();
		} else if(id.equals(P_ID)){
			return getId();
		} else if(id.equals(P_CLASSNAME)){
			return getClassName();
		} else if(id.equals(P_FACTORY)){
			return getFactory();
		} else if(id.equals(P_NULL)){
			return BooleanPropertyDescriptor.convertValue(nullVal);
		} else if(id.equals(P_PROPERTIES)){
			return getProperties();
		}
		return null;
	}

	public boolean isPropertySet(Object id) {
		if(id.equals(P_PARAMETER) || id.equals(P_KEY) || id.equals(P_ID) ||
		   id.equals(P_CLASSNAME) || id.equals(P_FACTORY) || id.equals(P_NULL)||
		   id.equals(P_PROPERTIES)){
			return true;
		}
		return false;
	}

	public void resetPropertyValue(Object id) {
	}

	public void setPropertyValue(Object id, Object value) {
		if(id.equals(P_PARAMETER)){
			setParameter((String)value);
		} else if(id.equals(P_KEY)){
			setKey((String)value);
		} else if(id.equals(P_ID)){
			setId((String)value);
		} else if(id.equals(P_CLASSNAME)){
			setClassName((String)value);
		} else if(id.equals(P_FACTORY)){
			setFactory((String)value);
		} else if(id.equals(P_NULL)){
			setNull(BooleanPropertyDescriptor.convertValue((Integer)value));
		} else if(id.equals(P_PROPERTIES)){
			setProperties((Properties)value);
		}
	}

}
