package tk.eclipse.plugin.struts.editors.models;

public class TilesAttributeModel {

    private final String TYPE_STRING = "string";
    private final String TYPE_DEFINITION = "definition";
    private final String TYPE_PAGE = "page";
    private final String TYPE_TEMPLATE = "template";
    
    private TilesDefinitionModel definition = null;
    private String name = null;
    private String value = null;
    private String type = null;
    
    public TilesAttributeModel() {
        super();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public void setDefinition(TilesDefinitionModel definition) {
        this.definition = definition;
    }

    public TilesDefinitionModel getDefinition() {
        return definition;
    }
    
    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return type;
    }

    public boolean isDefinition() {
        return TYPE_DEFINITION.equalsIgnoreCase(type) || 
            (type == null && getDefinition().getRoot().existsDefinition(value));
    }
    
    public boolean isPageOrTemplate() {
        // TODO: better way to find, if it is a file
        return TYPE_PAGE.equalsIgnoreCase(type) || TYPE_TEMPLATE.equalsIgnoreCase(type) ||
            (type == null && (value.startsWith("/") || value.endsWith(".jsp") || value.endsWith(".html") || value.endsWith(".htm") || value.endsWith(".xml")));
    }
    
    public boolean isString() {
        return TYPE_STRING.equalsIgnoreCase(type) || (!isDefinition() && !isPageOrTemplate());
    }
    
}
