package tk.eclipse.plugin.struts.editors.tree;

import java.beans.PropertyChangeEvent;
import java.util.List;

import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.editors.models.PageModel;

public class PageTreeEditPart extends AbstractMyTreeEditPart {

	protected List getModelChildren() {
		return ((PageModel) getModel()).getModelSourceConnections();
	}

	protected void refreshVisuals() {
		PageModel model = (PageModel)getModel();
		setWidgetText(model.getPath());
		setWidgetImage(StrutsPlugin.getDefault().getImage(StrutsPlugin.ICON_WEBPAGE));
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        String propName = evt.getPropertyName();
        if (PageModel.P_PATH.equals(propName)) {
            String path = (String) evt.getNewValue();
            if ("".equals(path)) {
                path = "<page>";
            }
            setWidgetText(path);
        }
	}

}
