package tk.eclipse.plugin.struts.properties;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

/**
 * The dialog to list, add, edit and remove &lt;form-property&gt;.
 * When users click &quot;add&quot; or &quot;edit&quot; button,
 * this dialog opens FormPropertyDialog to add or edit a property. 
 * 
 * @see tk.eclipse.plugin.struts.properties.FormPropertyDialog
 * @see tk.eclipse.plugin.struts.properties.FormPropertiesPropertyDescriptor
 * @author takezoe
 */
public class FormPropertiesDialog extends AbstractPropertiesDialog {

	private FormProperties props;
	
	public FormPropertiesDialog(Shell parentShell,FormProperties props) {
		super(parentShell);
		this.props = props;
		this.labelValue = "type";
	}

	protected void okPressed() {
		props = new FormProperties();
		TableItem[] items = table.getItems();
		for(int i=0;i<items.length;i++){
			props.addProperty(items[i].getText(0),items[i].getText(1),"","","",new Properties());
		}
		super.okPressed();
	}
	
	protected void addPressed() {
		FormPropertyDialog dialog = new FormPropertyDialog(getShell());
		if(dialog.open()==PropertyDialog.OK){
			TableItem item = new TableItem(table,SWT.NULL);
			item.setText(new String[]{dialog.getName(),dialog.getType()});
		}
	}
	
	protected void editPressed() {
		TableItem[] sel = table.getSelection();
		if(sel==null || sel.length==0){
			return;
		}
		String name  = sel[0].getText(0);
		String value = sel[0].getText(1);
		FormPropertyDialog dialog = new FormPropertyDialog(getShell(),name,value);
		if(dialog.open()==PropertyDialog.OK){
			sel[0].setText(new String[]{dialog.getName(),dialog.getType()});
		}
	}
	
	protected void initDialog() {
		getShell().setText("Form Properties");
		
		for(int i=0;i<props.size();i++){
			TableItem item = new TableItem(table,SWT.NULL);
			String[] text = new String[]{props.getName(i),props.getType(i)};
			item.setText(text);
		}
	}
	
	protected void removePressed() {
		table.remove(table.getSelectionIndices());
	}
	
	public FormProperties getProperties(){
		return this.props;
	}
	
}
