package tk.eclipse.plugin.struts.properties;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.PropertyDescriptor;

/**
 * The PropertyDescriptor to edit &lt;form-property&gt;.
 * This descriptor provides DialogCellEditor which opens FormPropertiesDialog
 * to edit list of &lt;form-property&gt;.
 * 
 * @see tk.eclipse.plugin.struts.properties.FormPropertiesDialog
 * @author Naoki Takezoe
 */
public class FormPropertiesPropertyDescriptor extends PropertyDescriptor {
	
	/**
	 * The constructor.
	 * 
	 * @param id
	 * @param displayName
	 */
	public FormPropertiesPropertyDescriptor(Object id, String displayName) {
		super(id, displayName);
	}
	
	public CellEditor createPropertyEditor(Composite parent) {
		FormPropertiesDialogCellEditor editor = new FormPropertiesDialogCellEditor(parent);
		if (getValidator() != null){
			editor.setValidator(getValidator());
		}
		return editor;
	}
	
	/** Cell Editor */
	private class FormPropertiesDialogCellEditor extends DialogCellEditor {
		
		public FormPropertiesDialogCellEditor(Composite parent) {
			super(parent);
		}
		
		protected Object openDialogBox(Control cellEditorWindow) {
			
			FormProperties props = (FormProperties)getValue();
			FormPropertiesDialog dialog = new FormPropertiesDialog(cellEditorWindow.getShell(),props);
			
			if(dialog.open()==PropertiesDialog.OK){
				props = dialog.getProperties();
			}
			
			return props;
		}

	}
}
