package tk.eclipse.plugin.struts.properties;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

/**
 * The dialog to list, add, edit and remove &lt;set-property&gt;.
 * 
 * @author takezoe
 */
public class PropertiesDialog extends AbstractPropertiesDialog {
	
	private Properties props;
	
	public PropertiesDialog(Shell parentShell,Properties props) {
		super(parentShell);
		this.props = props;
	}
	
	protected void okPressed() {
		props = new Properties();
		TableItem[] items = table.getItems();
		for(int i=0;i<items.length;i++){
			props.addProperty(items[i].getText(0),items[i].getText(1),"");
		}
		super.okPressed();
	}
	
	public Properties getProperties(){
		return this.props;
	}
	
	protected void addPressed() {
		PropertyDialog dialog = new PropertyDialog(getShell());
		if(dialog.open()==PropertyDialog.OK){
			TableItem item = new TableItem(table,SWT.NULL);
			item.setText(new String[]{dialog.getName(),dialog.getValue()});
		}
	}
	
	protected void editPressed() {
		TableItem[] sel = table.getSelection();
		if(sel==null || sel.length==0){
			return;
		}
		String name  = sel[0].getText(0);
		String value = sel[0].getText(1);
		PropertyDialog dialog = new PropertyDialog(getShell(),name,value);
		if(dialog.open()==PropertyDialog.OK){
			sel[0].setText(new String[]{dialog.getName(),dialog.getValue()});
		}
	}
	
	protected void initDialog() {
		getShell().setText("Properties");
		
		for(int i=0;i<props.size();i++){
			TableItem item = new TableItem(table,SWT.NULL);
			String[] text = new String[]{props.getName(i),props.getValue(i)};
			item.setText(text);
		}
	}
	
	protected void removePressed() {
		table.remove(table.getSelectionIndices());
	}
	
}
