package tk.eclipse.plugin.struts.properties;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.PropertyDescriptor;

/**
 * The PropertyDescriptor to edit &lt;set-property&gt;.
 * 
 * @author takezoe
 */
public class PropertiesPropertyDescriptor extends PropertyDescriptor {

	/**
	 * @param id
	 * @param displayName
	 */
	public PropertiesPropertyDescriptor(Object id, String displayName) {
		super(id, displayName);
	}
	
	public CellEditor createPropertyEditor(Composite parent) {
		PropertiesDialogCellEditor editor = new PropertiesDialogCellEditor(parent);
		if (getValidator() != null){
			editor.setValidator(getValidator());
		}
		return editor;
	}
	
	/** CellEditor */
	private class PropertiesDialogCellEditor extends DialogCellEditor {
		
		public PropertiesDialogCellEditor(Composite parent) {
			super(parent);
		}
		
		protected Object openDialogBox(Control cellEditorWindow) {
			
			Properties props = (Properties)getValue();
			PropertiesDialog dialog = new PropertiesDialog(cellEditorWindow.getShell(),props);
			
			if(dialog.open()==PropertiesDialog.OK){
				props = dialog.getProperties();
			}
			
			return props;
		}

	}
}
