package tk.eclipse.plugin.struts.template;

import java.io.IOException;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;

import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.Util;

public class StrutsTemplateAccess {
	
	private static final String CUSTOM_TEMPLATES_KEY 
		= StrutsPlugin.PLUGIN_ID + ".customtemplates";

	private static StrutsTemplateAccess fgInstance;
	private TemplateStore fStore;
	private ContributionContextTypeRegistry fRegistry;

	private StrutsTemplateAccess(){
	}
  
	public static StrutsTemplateAccess getDefault(){
		if(fgInstance==null){
			fgInstance = new StrutsTemplateAccess();
		}
		return fgInstance;
	}

	public TemplateStore getTemplateStore(){
		if (fStore == null){
			fStore = new ContributionTemplateStore(getContextTypeRegistry(), 
					StrutsPlugin.getDefault().getPreferenceStore(), CUSTOM_TEMPLATES_KEY);
			try {
				fStore.load();
			} catch (IOException e){
				Util.logException(e);
			}
		}
		return fStore;
	}

	public ContextTypeRegistry getContextTypeRegistry(){
		if (fRegistry == null){
			fRegistry = new ContributionContextTypeRegistry();
			fRegistry.addContextType(StrutsJSPContextType.STRUTS_JSP_CONTEXT_TYPE);
		}
		return fRegistry;
	}

	public IPreferenceStore getPreferenceStore(){
		return StrutsPlugin.getDefault().getPreferenceStore();
	}

	public void savePluginPreferences(){
		StrutsPlugin.getDefault().savePluginPreferences();
	}
}
