package tk.eclipse.plugin.struts.template;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.GlobalTemplateVariables;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class TemplateFileCreator {
	
	private HashMap fResolvers = new HashMap();
	
	/**
	 * Constructor.
	 * 
	 *
	 */
	public TemplateFileCreator(){
		addResolver(new GlobalTemplateVariables.Cursor());
		addResolver(new GlobalTemplateVariables.WordSelection());
		addResolver(new GlobalTemplateVariables.LineSelection());
		addResolver(new GlobalTemplateVariables.Dollar());
		addResolver(new GlobalTemplateVariables.Date());
		addResolver(new GlobalTemplateVariables.Year());
		addResolver(new GlobalTemplateVariables.Time());
		addResolver(new GlobalTemplateVariables.User());
		addResolver(new CharsetTemplateVariable());
	}
	
	private void addResolver(TemplateVariableResolver resolver){
		fResolvers.put(resolver.getType(),resolver);
	}
	
	/**
	 * Creates a file using Template.
	 */
	public void create(IFile file,Template template,String charset,IProgressMonitor monitor) 
		throws CoreException, BadLocationException, TemplateException{
		
		InputStream contents = new ByteArrayInputStream(getContent(template,charset).getBytes());
		file.create(contents, false, new SubProgressMonitor(monitor, 1));
	}
	
	private String getContent(Template template,String charset) 
		throws BadLocationException, TemplateException {
		
		DefaultContext context = new DefaultContext();
		context.setVariable(CharsetTemplateVariable.VAR_NAME,charset);
	    TemplateBuffer buffer = context.evaluate(template);
	    String content = buffer.getString();
	    return content;
	}
	
	private class DefaultResolver extends TemplateVariableResolver{
		public DefaultResolver(String type, String description){
			super(type, description);
	    }
	}
	
	/**
	 * Implementation of TemplateContext.
	 */
	private class DefaultContext extends TemplateContext {
		
		public DefaultContext(){
			super(null);
		}
		
		public boolean canEvaluate(Template template) {
			return true;
		}
		
		public TemplateBuffer evaluate(Template template)
				throws BadLocationException, TemplateException {
//			if (!fTemplateContextId.equals(template.getContextTypeId()))
//				throw new TemplateException("wrong context!");

			TemplateTranslator translator = new TemplateTranslator();
			TemplateBuffer buffer = translator.translate(template);

			resolve(buffer, this);
			return buffer;
		}
	}
	
	private void resolve(TemplateBuffer buffer, TemplateContext context) 
		throws MalformedTreeException, BadLocationException {
		
		TemplateVariable[] variables = buffer.getVariables();
		
		List positions = variablesToPositions(variables);
		List edits = new ArrayList(5);
		
		// iterate over all variables and try to resolve them
		for (int i = 0; i != variables.length; i++){
			TemplateVariable variable = variables[i];
			
			if (variable.isUnambiguous()){
				continue;
			}
			
			// remember old values
			int[] oldOffsets = variable.getOffsets();
			int oldLength = variable.getLength();
			String oldValue = variable.getDefaultValue();
			
			String type = variable.getType();
			TemplateVariableResolver resolver = (TemplateVariableResolver) fResolvers.get(type);
			if (resolver == null)
				resolver = new DefaultResolver(type, "");
			resolver.resolve(variable, context);
			
			String value = variable.getDefaultValue();
			
			if (!oldValue.equals(value)){
				// update buffer to reflect new value
				for (int k = 0; k != oldOffsets.length; k++){
					edits.add(new ReplaceEdit(oldOffsets[k], oldLength, value));
				}
			}
		}
		
		IDocument document = new Document(buffer.getString());
		MultiTextEdit edit = new MultiTextEdit(0, document.getLength());
		edit.addChildren((TextEdit[]) positions.toArray(new TextEdit[positions.size()]));
		edit.addChildren((TextEdit[]) edits.toArray(new TextEdit[edits.size()]));
		edit.apply(document, TextEdit.UPDATE_REGIONS);
		
		positionsToVariables(positions, variables);
		
		buffer.setContent(document.get(), variables);
		
	}
	
	private static List variablesToPositions(TemplateVariable[] variables){
		List positions = new ArrayList(5);
		for (int i = 0; i != variables.length; i++){
			int[] offsets = variables[i].getOffsets();
			for (int j = 0; j != offsets.length; j++){
				positions.add(new RangeMarker(offsets[j], 0));
			}
		}
		return positions;
	}
	
	private static void positionsToVariables(List positions, TemplateVariable[] variables){
		Iterator iterator = positions.iterator();
		
		for (int i = 0; i != variables.length; i++){
			TemplateVariable variable = variables[i];
			
			int[] offsets = new int[variable.getOffsets().length];
			for (int j = 0; j != offsets.length; j++){
				offsets[j] = ((TextEdit) iterator.next()).getOffset();
			}
			variable.setOffsets(offsets);
		}
	}

}
