package tk.eclipse.plugin.struts.validator;

import java.util.HashMap;
import java.util.Map;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLParser;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.IOUtil;
import tk.eclipse.plugin.struts.StrutsConfigResolver;
import tk.eclipse.plugin.struts.StrutsProject;
import tk.eclipse.plugin.xmleditor.editors.XMLValidationHandler;

public abstract class AbstractStrutsXMLValidator {

	protected StrutsProject project;
	protected IFile file;
	protected HTMLProjectParams params;
	protected FuzzyXMLDocument doc;

	private String contents;
	
	public AbstractStrutsXMLValidator(StrutsProject project,IFile file){
		this.project = project;
		this.file = file;
	}
	
	public void doValidate(){
		// DTD based validation
		try {
			// remove all markers
			file.deleteMarkers(IMarker.PROBLEM,false,0);
			
			SAXParserFactory spfactory = SAXParserFactory.newInstance();
			spfactory.setValidating(true);
			SAXParser parser = spfactory.newSAXParser();
			XMLReader reader = parser.getXMLReader(); 
			
			reader.setEntityResolver(new StrutsConfigResolver());
			reader.setErrorHandler(new XMLValidationHandler(file));
			reader.parse(new InputSource(file.getContents()));
		} catch(Exception ex){
		}
		// Logical validation
		try {
			params     = new HTMLProjectParams(file.getProject());
			contents   = new String(IOUtil.readStream(file.getContents()));
			contents   = contents.replaceAll("\r\n"," \n");
			contents   = contents.replaceAll("\r"  ,"\n");
			doc        = new FuzzyXMLParser().parse(file.getContents());
			
			executeValidate();
		} catch(Exception ex){
		}
		
	}
	
	protected abstract void executeValidate();
	
	/////////////////////////////////////////////////////////////////////////////
	//
	// Utility methods
	//
	/////////////////////////////////////////////////////////////////////////////
	
	/** Returns the line number from an offset. */
	protected int getLineAtOffset(int offset){
		String text = contents.substring(0,offset);
		return text.split("\n").length;
	}
	
	/** Returns an offset of attribute value from an offset of attribute name. */
	protected int getAttrValueOffset(int offset){
		int valueStart = 0;
		
		valueStart = contents.indexOf("\"",offset);
		if(valueStart==-1){
			valueStart = contents.indexOf("=")+1;
		}
		
		return valueStart;
	}
	
	/** Create error marker in the attribute value. */
	protected void createAttributeValueMarker(FuzzyXMLAttribute attr,String message) throws CoreException {
		createMarker(
				getAttrValueOffset(attr.getOffset()+1),
				attr.getOffset()+attr.getLength(),
				getLineAtOffset(attr.getOffset()+1),
				message);
	}

	/** Create resource marker. */
	protected void createMarker(int start,int end,int line,String message) throws CoreException {
		IMarker marker = file.createMarker(IMarker.PROBLEM);
		Map map = new HashMap();
		map.put(IMarker.SEVERITY, new Integer(IMarker.SEVERITY_ERROR));
		map.put(IMarker.MESSAGE, message);
		map.put(IMarker.LINE_NUMBER,new Integer(line));
		map.put(IMarker.CHAR_START,new Integer(start));
		map.put(IMarker.CHAR_END,new Integer(end));
		marker.setAttributes(map);
	}
}
