package tk.eclipse.plugin.struts.validator;

import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.XPath;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Path;

import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.StrutsProject;
import tk.eclipse.plugin.struts.Util;

/**
 * This is the validator for struts-config.xml.
 * <ul>
 *   <li>DTD based XML validation.</li>
 *   <li>Tests whether paths specified by type attributes or className attributes exist or not.</li>
 *   <li>Tests whether JSPs or Actions specified path attribute of forward element exist or not.</li>
 * </ul>
 * 
 * @author Naoki Takezoe
 */
public class StrutsConfigValidator extends AbstractStrutsXMLValidator {
	
	//private List tilesPages;
	private String[] tilesDefinitions;
	private String extention;
	private String moduleName;
	
	public StrutsConfigValidator(StrutsProject project, IFile file, String moduleName){
		super(project,file);
		
		this.extention = project.getExtension();
		if(this.extention==null){
			this.extention = ".do";
		}
		
		this.moduleName = moduleName;
	}
	
	protected void executeValidate() {
		//tilesPages = new Tiles(file.getProject()).getTilesPathList();
		tilesDefinitions = new StrutsProject(file.getProject()).getTilesDefinition(moduleName);
		validateElement(doc.getDocumentElement());
	}
	
	/**
	 * Validates an element of struts-config.xml.
	 * 
	 * @param element an element
	 */
	private void validateElement(FuzzyXMLElement element){
		FuzzyXMLAttribute[] attrs = element.getAttributes();
		for(int i=0;i<attrs.length;i++){
			try {
				if(attrs[i].getName().equals("type") || attrs[i].getName().equals("className")){
					if(!attrs[i].getValue().equals("") 
							&& attrs[i].getValue().indexOf('{') < 0 
							&& !project.existsClass(attrs[i].getValue())){
						createAttributeValueMarker(
								attrs[i],
								Util.createMessage(
										StrutsPlugin.getResourceString("error.notexists"),
										new String[]{attrs[i].getValue()})
						);
					}
				} else if(!element.getName().equals("action") && attrs[i].getName().equals("path")){
					String attrValue = attrs[i].getValue();
					if(attrValue.endsWith(".jsp")){
						attrValue = moduleName + "/" + attrValue;
					}
					if(!attrs[i].getValue().equals("") && attrValue.indexOf('{') < 0 && !existsPath(attrValue)){
						createAttributeValueMarker(
								attrs[i],
								Util.createMessage(
										StrutsPlugin.getResourceString("error.notexists"),
										new String[]{attrs[i].getValue()})
						);
					}
				}
			} catch(Exception ex){
				Util.logException(ex);
			}
		}
		FuzzyXMLNode[] nodes = element.getChildren();
		for(int i=0;i<nodes.length;i++){
			if(nodes[i] instanceof FuzzyXMLElement){
				validateElement((FuzzyXMLElement)nodes[i]);
			}
		}
	}
	
	//////////////////////////////////////////////////////////////////////////////////////
	//
	// Utilities
	//
	//////////////////////////////////////////////////////////////////////////////////////
	/** Tests whether path does exist or not. */
	private boolean existsPath(String path){
		if(path.endsWith(extention)){
			path = path.substring(0,path.indexOf(extention));
			FuzzyXMLNode[] nodes = XPath.selectNodes(doc.getDocumentElement(),"/struts-config/action-mappings/action");
			for(int i=0;i<nodes.length;i++){
				FuzzyXMLElement action = (FuzzyXMLElement)nodes[i];
				String actionPath = action.getAttributeNode("path").getValue();
				if(path.equals(actionPath)){
					return true;
				}
			}
		} else {
			if(path.indexOf("?") > 0){
				path = path.substring(0,path.indexOf("?"));
			}
			for(int i=0;i<tilesDefinitions.length;i++){
				if(tilesDefinitions[i].equals(path)){
					return true;
				}
			}
			IFile jsp = file.getProject().getFile(new Path(params.getRoot()).append(path));
			if(jsp.exists()){
				return true;
			}
		}
		
		return false;
	}
}
