package tk.eclipse.plugin.struts.validator;

import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;

import org.eclipse.core.resources.IFile;

import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.StrutsProject;
import tk.eclipse.plugin.struts.Util;

/**
 * Validator for configuration files of Tiles.
 * 
 * @author Naoki Takezoe
 */
public class TilesValidator extends AbstractStrutsXMLValidator {
	
	private String[] definitions;
	private String moduleName;
	
	public TilesValidator(StrutsProject project, IFile file, String moduleName){
		super(project,file);
		this.moduleName = moduleName;
	}
	
	protected void executeValidate(){
		definitions = project.getTilesDefinition(moduleName);
		validateElement(doc.getDocumentElement());
	}
	
	private void validateElement(FuzzyXMLElement element){
		try {
			if(element.getName().equals("definition")){
				FuzzyXMLAttribute[] attrs = element.getAttributes();
				for(int i=0;i<attrs.length;i++){
					if(attrs[i].getName().equals("path")){
						String value = attrs[i].getValue();
						if(!project.existsJSP(value, null)){
							createAttributeValueMarker(attrs[i],
									Util.createMessage(
											StrutsPlugin.getResourceString("error.notexists"),
											new String[]{value}));
						}
					} else if(attrs[i].getName().equals("extends")){
						String value = attrs[i].getValue();
						if(!existsDifinition(value)){
							createAttributeValueMarker(attrs[i],
									Util.createMessage(
											StrutsPlugin.getResourceString("error.notDefined"),
											new String[]{value}));
						}
					}
				}
			}
			if(element.getName().equals("put")){
				FuzzyXMLAttribute[] attrs = element.getAttributes();
				for(int i=0;i<attrs.length;i++){
					if(attrs[i].getName().equals("name")){
						
					} else if(attrs[i].getName().equals("value")){
						String value = attrs[i].getValue();
						if(value.endsWith(".jsp") && !project.existsJSP(value, null)){
							createAttributeValueMarker(attrs[i],
									Util.createMessage(
											StrutsPlugin.getResourceString("error.notexists"),
											new String[]{value}));
						}
					}
				}
			}
		} catch(Exception ex){
			Util.logException(ex);
		}
		
		FuzzyXMLNode[] nodes = element.getChildren();
		for(int i=0;i<nodes.length;i++){
			if(nodes[i] instanceof FuzzyXMLElement){
				validateElement((FuzzyXMLElement)nodes[i]);
			}
		}
	}
	
	/**
	 * Tests whether definition which denoted by an argument is exist or not exist.
	 * 
	 * @param name A definition name.
	 * @return true if a definition name is exist; false otherwise
	 */
	private boolean existsDifinition(String name){
		for(int i=0;i<definitions.length;i++){
			if(name.equals(definitions[i])){
				return true;
			}
		}
		return false;
	}
}
