package tk.eclipse.plugin.struts.validator;

import java.util.Arrays;

import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;

import org.eclipse.core.resources.IFile;

import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.struts.FormInfo;
import tk.eclipse.plugin.struts.PropertyInfo;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.StrutsProject;
import tk.eclipse.plugin.struts.Util;

/**
 * Validator for configuration files of Validator.
 * 
 * @author Naoki Takezoe
 */
public class ValidatorValidator extends AbstractStrutsXMLValidator {
	
	private FormInfo[] forms;
	private String[] ruleNames;
	private String moduleName;
	
	public ValidatorValidator(StrutsProject project,IFile file,String moduleName){
		super(project,file);
		this.moduleName = moduleName;
		this.ruleNames = Util.getValidatorRules(project, moduleName);
		Arrays.sort(this.ruleNames);
	}
	
	protected void executeValidate(){
		try {
			forms = project.getActionForms(moduleName);
			validateElement(doc.getDocumentElement());
		} catch(Exception ex){
		}
	}
	
	private void validateElement(FuzzyXMLElement element){
		try {
			if(element.getName().equals("form")){
				FuzzyXMLAttribute attr = element.getAttributeNode("name");
				if(attr!=null){
					String name = attr.getValue();
					if(!existsForm(name)){
						// ActionForm doesn't exist
						createAttributeValueMarker(attr,
								Util.createMessage(
										StrutsPlugin.getResourceString("error.noActionForm"),
										new String[]{name}));
						return;
					}
				}
			}
			
			if(element.getName().equals("field")){
				FuzzyXMLAttribute attr = element.getAttributeNode("property");
				if(attr!=null){
					FuzzyXMLElement parent = (FuzzyXMLElement)element.getParentNode();
					String form = parent.getAttributeNode("name").getValue();
					
					String property = attr.getValue();
					if(!existsProperty(form,property)){
						// Property doesn't exist
						createAttributeValueMarker(attr,
								Util.createMessage(
										StrutsPlugin.getResourceString("error.noProperty"),
										new String[]{form,property}));
						return;
					}
				}
				
				FuzzyXMLAttribute depends = element.getAttributeNode("depends");
				if(depends!=null){
					String[] rules = depends.getValue().split(",");
					for(int i=0;i<rules.length;i++){
						if(Arrays.binarySearch(this.ruleNames, rules[i].trim()) < 0){
							createAttributeValueMarker(depends, 
									Util.createMessage(
											StrutsPlugin.getResourceString("error.noValidationRule"),
											new String[]{rules[i].trim()}));
							return;
						}
					}
				}
			}
		} catch(Exception ex){
		}
		
		FuzzyXMLNode[] children = element.getChildren();
		for(int i=0;i<children.length;i++){
			if(children[i] instanceof FuzzyXMLElement){
				validateElement((FuzzyXMLElement)children[i]);
			}
		}
	}
	
	
	private String getFormFromPath(String path){	
		IFile[] files = project.getStrutsConfigXML(moduleName);
		
		for(int i=0;i<files.length;i++){
			try {
				FuzzyXMLDocument doc = new FuzzyXMLParser().parse(files[i].getContents());
				FuzzyXMLNode[] nodes = HTMLUtil.selectXPathNodes(
						doc.getDocumentElement(),"//struts-config/action-mappings/action[@path=\""+path+"\"]");
				if (nodes.length > 0){
						FuzzyXMLElement element = (FuzzyXMLElement)nodes[0];
						return element.getAttributeNode("name").getValue();
						
					} 
				
			} catch(Exception ex){
				Util.logException(ex);
			}			
		}
		return null;
	}
	
	/**
	 * Validates the form name.
	 */
	private boolean existsForm(String name){
		//ValidatorActionForm
		if (name.startsWith("/")){
			name=getFormFromPath(name);
		}
		for(int i=0;i<forms.length;i++){
			if(forms[i].getFormName().equals(name)){
				return true;
			}
		}
		return false;
	}
	
	/**
	 * Validates the form property.
	 */
	private boolean existsProperty(String name,String property){
		//ValidatorActionForm
		if (name.startsWith("/")){
			name=getFormFromPath(name);
		}
		property = property.replaceAll("\\[[0-9]+\\]","");
		String[] dim = property.indexOf('.') >=0 ? (property + " ").split("\\.") : new String[]{property};
		for(int i=0;i<forms.length;i++){
			if(forms[i].getFormName().equals(name)){
				PropertyInfo[] props = forms[i].getProperties();
				for(int k=0;k<dim.length;k++){
					for(int j=0;j<props.length;j++){
						if(props[j].getPropertyName().equals(dim[k].trim())){
							if(k == dim.length-1){
								return true;
							} else {
								props = props[j].getProperties();
								j = 0;
							}
						}
					}
				}
			}
		}
		return false;
	}
}