package tk.eclipse.plugin.struts.wizards;

import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.internal.ui.wizards.NewClassCreationWizard;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;

import tk.eclipse.plugin.struts.StrutsPlugin;

/**
 * A wizard for creation a Struts ActionForm file.
 * 
 * @author Naoki Takezoe
 */
public class ActionFormWizard extends NewClassCreationWizard {

	private String className;
	
	public ActionFormWizard() {
		super();
		setWindowTitle(StrutsPlugin.getResourceString("wizard.actionform.title"));
	}
	
	public void setClassName(String className){
		this.className = className;
	}

	public void addPages() {
		super.addPages();
		NewClassWizardPage fPage = (NewClassWizardPage)getPages()[0];
		fPage.setSuperClass("org.apache.struts.action.ActionForm",true);
		if(className!=null){
			int index = className.lastIndexOf('.');
			if(index!=-1){
				String packageName = className.substring(0,index);
				className = className.substring(index+1,className.length());
				IPackageFragment pack = fPage.getPackageFragmentRoot().getPackageFragment(packageName);
				fPage.setPackageFragment(pack,true);
			}
			fPage.setTypeName(className,true);
		}
	}
}
