package tk.eclipse.plugin.struts.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.editors.models.ActionModel;

/**
 * A wizard window which modify ActionModel
 * <p>
 * from Naoki: 
 * I think this wizard isn't fit for the StrutsIDE/FacesIDE general operativeness.
 * <ol>
 *   <li>Double clicking should open the action/jsp source code in the editor.</li>
 *   <li>Model properties should are edited in the properties view.</li>
 *   <li>This wizard can't be called from the [File] &gt; [New] because 
 *       this wizard requires the <code>ActionModel</code> and <code>CommandStack</code>.</li>
 * </ol>
 * So I propose: StrutsIDE doesn't take this wizard.
 * 
 * @author Masayuki Kimura
 * @author Naoki Takezoe
 * @deprecated
 */
public class ConfigurationActionWizard extends Wizard implements INewWizard {

	private ActionModel model;
	private CommandStack stack;
	private ConfigurationActionWizardPage page1;
	private NewClassWizardPage page2;
	private IJavaProject project;

	public ConfigurationActionWizard(ActionModel model, CommandStack stack) {
		super();
		this.model = model;
		this.stack = stack;
		setWindowTitle(StrutsPlugin.getResourceString("wizard.action.title"));
	}
	
	public boolean performFinish() {
		// modify the action model
		stack.execute(new Command(){
			public void execute(){
				model.setPath(page1.pathText.getText());
				model.setType(page1.typeText.getText());
				model.setName(page1.comboFormBean.getText());
				model.setScope(page1.comboScope.getText());
			}
		});
		
		// Creates the action class
		if(page1.createClass.getSelection()){
			try {
				page2.createType(new NullProgressMonitor());
				IResource resource = page2.getCreatedType().getResource();
				IDE.openEditor(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), 
						(IFile)resource);
			} catch(Exception ex){
				Util.logException(ex);
			}
		}
		
		return true;
	}
	
	public void addPages() {
		page1 = new ConfigurationActionWizardPage(project, "CoonfigrationActionWizard", model);
		page2 = new NewClassWizardPage();
		addPage(page1);
		addPage(page2);
	}

	public void init(IWorkbench workbench, IStructuredSelection selection) {
		this.project = (IJavaProject)selection.getFirstElement();
	}

}
