package tk.eclipse.plugin.struts.wizards;

import java.util.List;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.editors.MultiPageStrutsConfigEditor;
import tk.eclipse.plugin.struts.editors.models.ActionModel;
import tk.eclipse.plugin.struts.editors.models.FormBeanModel;
import tk.eclipse.plugin.struts.editors.models.RootModel;

/**
 * Double-clicking ActionModel icon makes key elements of ActionModel visualize.
 * <p>
 * See the {@link ConfigurationActionWizard} javadoc about the reason of deprecation.
 * 
 * @author Masayuki Kimura
 * @author Naoki Takezoe
 * @deprecated
 * @see ConfigurationActionWizard
 */
public class ConfigurationActionWizardPage extends WizardPage {

	protected Text pathText;
	protected Text typeText;
	protected ActionModel model;
	protected Combo comboFormBean;
	protected Combo comboScope;
	protected Button createClass;
	private IJavaProject project;
	
	protected ConfigurationActionWizardPage(IJavaProject project, String pageName, ActionModel model) {
		super(pageName);
		this.model = model;
		this.project = project;
		setTitle(StrutsPlugin.getResourceString("wizard.action.title"));
		setDescription(StrutsPlugin.getResourceString("wizard.action.description"));
	}
	
	private static Label createLabel(Composite parent, String text){
		Label label = new Label(parent, SWT.NULL);
		label.setText(text);
		return label;
	}
	
	private void doValidate(){
		if(pathText.getText().length()==0){
			setErrorMessage(Util.createMessage(
					StrutsPlugin.getResourceString("error.required"), 
					new String[]{"path"}));
			setPageComplete(false);
			return;
		}
		if(typeText.getText().length()==0){
			setErrorMessage(Util.createMessage(
					StrutsPlugin.getResourceString("error.required"), 
					new String[]{"type"}));
			setPageComplete(false);
			return;
		}
		setPageComplete(true);
		setErrorMessage(null);
	}
	
	public void createControl(Composite parent) {
		final Composite container = new Composite(parent, SWT.NULL);
		container.setLayout(new GridLayout(3, false));
		
		createLabel(container, "path:");
		pathText = new Text(container, SWT.BORDER | SWT.SINGLE);
        pathText.setText(model.getPath());
        pathText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        pathText.addModifyListener(new ModifyListener(){
			public void modifyText(ModifyEvent evt) {
				doValidate();
			}
        });
        createLabel(container, "");

        // type
		createLabel(container, "type:");

        typeText = new Text(container, SWT.BORDER | SWT.SINGLE);
        typeText.setText(model.getType());
        typeText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        typeText.addModifyListener(new ModifyListener(){
			public void modifyText(ModifyEvent evt) {
				doValidate();
			}
        });
        
        // search button
        Button button = new Button(container, SWT.PUSH);
        button.setText(StrutsPlugin.getResourceString("wizard.label.browse"));
        button.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                handleBrowse("action class", "action class", container, typeText);
            }
        });
        
        createLabel(container, "");
        createClass = new Button(container, SWT.CHECK);
        createClass.setText(StrutsPlugin.getResourceString("wizard.label.createActionClass"));
        createClass.addSelectionListener(new SelectionAdapter(){
        	public void widgetSelected(SelectionEvent e){
        		doValidate();
        	}
        });
        createLabel(container, "");

		createLabel(container, "scope:");
        // scope
        comboScope = new Combo(container, SWT.READ_ONLY);
        comboScope.add("");
        comboScope.add("request");
        comboScope.add("session");
        if ("request".equals(model.getScope())){
        	comboScope.select(1);
        } else if ("session".equals(model.getScope())){
        	comboScope.select(2);
        } else {
        	comboScope.select(0);
        }
        comboScope.setLayoutData(new GridData());
        createLabel(container, "");

        // form
		createLabel(container, "form:");
        
        comboFormBean = new Combo(container, SWT.READ_ONLY);
        comboFormBean.add("");
        MultiPageStrutsConfigEditor strutsconfigEditor = (MultiPageStrutsConfigEditor) HTMLUtil
                .getActiveEditor();
        RootModel root = strutsconfigEditor.getRoot();
        List list = root.getChildren();
        for (int i = 0; list.size() > i; i++) {
            Object obj = list.get(i);
            if (obj instanceof FormBeanModel) {
                FormBeanModel tmp = (FormBeanModel) obj;
                comboFormBean.add(tmp.getName());
                if (tmp.getName() != null && model.getName().equals(tmp.getName()))
                	comboFormBean.select(i + 1);
            }
        }
        comboFormBean.setLayoutData(new GridData());
		setControl(container);
		
		doValidate();
	}
	
    public IWizardPage getNextPage() {
    	if(!createClass.getSelection()){
    		return null;
    	}
    	
    	NewClassWizardPage nextPage = (NewClassWizardPage)super.getNextPage();
    	try {
	    	nextPage.setSuperClass("org.apache.struts.action.Action", true);
			IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
			if(roots.length > 0){
				nextPage.setPackageFragmentRoot(roots[0], true);
			}
			
	    	String className = typeText.getText();
			int index = className.lastIndexOf('.');
			if(index!=-1){
				String packageName = className.substring(0,index);
				className = className.substring(index+1,className.length());
				if(roots.length > 0){
					IPackageFragment fragment = roots[0].getPackageFragment(packageName);
					nextPage.setPackageFragment(fragment, true);
				}
			}
			nextPage.setTypeName(className, false);
    	} catch(Exception ex){
    		Util.logException(ex);
    	}
    	
	    return nextPage;
	}
    
	protected void handleBrowse(String id, String displayname, Control control,
            Text text) {
    	IEditorPart editorPart = HTMLUtil.getActiveEditor();
		
		IFileEditorInput input = (IFileEditorInput)editorPart.getEditorInput();
		IJavaProject project = JavaCore.create(input.getFile().getProject());
    	HTMLUtil.openClassSelectDialog(project, control);
    }
}
