package tk.eclipse.plugin.struts.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.jspeditor.editors.JSPEditor;
import tk.eclipse.plugin.jspeditor.editors.JSPSourceEditor;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.template.TemplateFileCreator;

/**
 * A wizard for creation Struts JSP file.
 * 
 * @author Naoki Takezoe
 */
public class JSPWizard extends Wizard implements INewWizard {
	
	private JSPWizardPage page;
	private ISelection selection;
	private String fileName = "newfile.jsp";
	private ResourceBundle resource = StrutsPlugin.getDefault().getResourceBundle();

	/**
	 * Constructor for SampleNewWizard.
	 */
	public JSPWizard() {
		super();
		setNeedsProgressMonitor(true);
		setWindowTitle(resource.getString("wizard.jsp.title"));
	}
	
	/**
	 * Sets a filename that is displayed in default.
	 */
	public void setFileName(String fileName){
		this.fileName = fileName;
	}
	
	/**
	 * Adding the page to the wizard.
	 */
	public void addPages() {
		page = new JSPWizardPage(selection,fileName);
		addPage(page);
	}

	/**
	 * This method is called when 'Finish' button is pressed in
	 * the wizard. We will create an operation and run it
	 * using wizard as execution context.
	 */
	public boolean performFinish() {
		
		final String   containerName = page.getContainerName();
		final String   fileName      = page.getFileName();
		final Template template      = page.getTemplate();
		
		IRunnableWithProgress op = new IRunnableWithProgress() {
			public void run(IProgressMonitor monitor) throws InvocationTargetException {
				try {
					doFinish(containerName, fileName, template, monitor);
				} catch (CoreException e) {
					throw new InvocationTargetException(e);
				} finally {
					monitor.done();
				}
			}
		};
		try {
			getContainer().run(true, false, op);
		} catch (InterruptedException e) {
			return false;
		} catch (InvocationTargetException e) {
			Throwable realException = e.getTargetException();
			Util.openErrorDialog(realException);
			return false;
		}
		return true;
	}
	
	/**
	 * The worker method. It will find the container, create the
	 * file if missing or just replace its contents, and open
	 * the editor on the newly created file.
	 */
	private void doFinish(String containerName,String fileName,Template template,IProgressMonitor monitor) throws CoreException {
		// create a sample file
		monitor.beginTask(Util.createMessage(
				this.resource.getString("wizard.message.creation"),new String[]{fileName}), 2);
		
		IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
		IResource resource = root.findMember(new Path(containerName));
//		if (!resource.exists() || !(resource instanceof IContainer)) {
//			Util.throwCoreException(Util.createMessage(
//					this.resource.getString("error.notexists"),
//					new String[]{containerName}));
//		}
		IContainer container = (IContainer) resource;
		final IFile file = container.getFile(new Path(fileName));
		
		String charset = HTMLUtil.getProjectCharset(file.getProject());
//		try {
//			charset = file.getProject().getDefaultCharset();
//		} catch(CoreException ex){
//			// Getting charset is failed.
//		}
		
		try {
			TemplateFileCreator creator = new TemplateFileCreator();
			creator.create(file,template,charset,monitor);
		} catch (Exception e) {
			// Creation new file is failed.
		}
		monitor.worked(1);
		monitor.setTaskName(this.resource.getString("wizard.message.openfile"));
		getShell().getDisplay().asyncExec(new Runnable() {
			public void run() {
				IWorkbenchPage page =
					PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
				try {
					IDE.openEditor(page, file, JSPEditor.class.getName());
				} catch (PartInitException e) {
				}
			}
		});
		monitor.worked(1);
	}

	/**
	 * We will accept the selection in the workbench to see if
	 * we can initialize from it.
	 * @see IWorkbenchWizard#init(IWorkbench, IStructuredSelection)
	 */
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		this.selection = selection;
	}
}