package tk.eclipse.plugin.struts.wizards;

import java.util.ResourceBundle;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionValidator;

import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.Util;

public class StrutsWizardPage extends WizardPage {
	
	private Button library;
	private Button tld;
	private Button strutsConfig;
	private Button message;
	private Button webXml;
	private Text containerText;
	private ISelection selection;
	private ResourceBundle resource = StrutsPlugin.getDefault().getResourceBundle();
	private Text mapping;
	
	public StrutsWizardPage(ISelection selection) {
		super("wizardPage");
		setTitle(resource.getString("wizard.strutsSupport.title"));
		setDescription(resource.getString("wizard.strutsSupport.decription"));
		this.selection = selection;
	}
	
	public void createControl(Composite parent) {
		Composite container = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		container.setLayout(layout);
		layout.numColumns = 3;
		layout.verticalSpacing = 9;
		
		Label label = new Label(container, SWT.NULL);
		label.setText(resource.getString("wizard.label.webappRoot"));

		containerText = new Text(container, SWT.BORDER | SWT.SINGLE);
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		containerText.setLayoutData(gd);
		containerText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				dialogChanged();
			}
		});

		Button button = new Button(container, SWT.PUSH);
		button.setText(resource.getString("wizard.label.browse"));
		button.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				handleBrowse();
			}
		});
		
		label = new Label(container, SWT.NULL);
		label.setText(resource.getString("wizard.label.mapping"));
		mapping = new Text(container, SWT.BORDER);
		mapping.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		mapping.setText("*.do");
		mapping.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				dialogChanged();
			}
		});
		label = new Label(container, SWT.NULL); // fill
		
		library = new Button(container,SWT.CHECK);
		library.setText(resource.getString("wizard.label.addStrutsLibrary"));
		library.setSelection(true);
		library.setLayoutData(createCheckBoxGridData());
		
		tld = new Button(container,SWT.CHECK);
		tld.setText(resource.getString("wizard.label.addStrutsTLD"));
		tld.setSelection(true);
		tld.setLayoutData(createCheckBoxGridData());
		
		strutsConfig = new Button(container,SWT.CHECK);
		strutsConfig.setText(resource.getString("wizard.label.createStrutsConfig"));
		strutsConfig.setSelection(true);
		strutsConfig.setLayoutData(createCheckBoxGridData());
		strutsConfig.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent evt){
				StrutsWizardPage2 page2 = (StrutsWizardPage2)getWizard().getNextPage(StrutsWizardPage.this);
				page2.setEnabled(strutsConfig.getSelection());
			}
		});
		
		message = new Button(container,SWT.CHECK);
		message.setText(resource.getString("wizard.label.createMessageResources"));
		message.setSelection(true);
		message.setLayoutData(createCheckBoxGridData());
		
		webXml = new Button(container,SWT.CHECK);
		webXml.setText(resource.getString("wizard.label.createWebXML"));
		webXml.setSelection(true);
		webXml.setLayoutData(createCheckBoxGridData());
		webXml.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent evt){
				mapping.setEnabled(webXml.getSelection());
			}
		});
		
		initialize();
		dialogChanged();
		setControl(container);
	}
	
	private GridData createCheckBoxGridData(){
		GridData gd = new GridData();
		gd.horizontalSpan = 3;
		return gd;
	}
	
	/**
	 * Tests if the current workbench selection is a suitable
	 * container to use.
	 */
	private void initialize() {
		if (selection!=null && selection.isEmpty()==false && selection instanceof IStructuredSelection) {
			IStructuredSelection ssel = (IStructuredSelection)selection;
			if (ssel.size()>1) return;
			Object obj = ssel.getFirstElement();
			
			if(obj instanceof IJavaProject){
				containerText.setText(((IJavaProject)obj).getProject().getFullPath().toString());
			} else if(obj instanceof IJavaElement){
				containerText.setText(((IJavaElement)obj).getJavaProject().getProject().getFullPath().toString());
			} else if(obj instanceof IProject){
				containerText.setText(((IProject)obj).getFullPath().toString());
			} else if(obj instanceof IFolder){
				containerText.setText(((IFolder)obj).getFullPath().toString());
			} else if(obj instanceof IFile){
				containerText.setText(((IFile)obj).getParent().getFullPath().toString());
			}
		}
	}

	/**
	 * Uses the standard container selection dialog to
	 * choose the new value for the container field.
	 */
	private void handleBrowse() {
		IContainer initial = null;
		
		if(containerText.getText().length() > 0){
			IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
			IResource resource = root.findMember(containerText.getText());
			if(resource!=null && resource.exists() && resource instanceof IContainer){
				initial = (IContainer)resource;
			}
		}
		
		if(initial == null){
			initial = ResourcesPlugin.getWorkspace().getRoot();
		}
		
		ContainerSelectionDialog dialog = new ContainerSelectionDialog(
				getShell(), initial, false,
				resource.getString("wizard.message.selectWebAppRoot"));
		
		dialog.setValidator(new ISelectionValidator(){
			public String isValid(Object selection){
				try {
					if(selection!=null){
						IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
						IResource resource = root.findMember((IPath)selection);
						if(resource!=null){
							if(resource.getProject().hasNature(StrutsPlugin.JAVA_PROJECT_NATURE)){
								return null;
							}
						}
					}
					return resource.getString("error.noJavaProject");
				} catch(Exception ex){
					return ex.toString();
				}
			}
		});
		if (dialog.open() == ContainerSelectionDialog.OK) {
			Object[] result = dialog.getResult();
			if (result.length == 1) {
				containerText.setText(result[0].toString());
			}
		}
	}
	
	private void dialogChanged() {
		String container = getWebAppRoot();
		if (container.length() == 0) {
			updateStatus(Util.createMessage(resource.getString("error.required"),
					new String[]{resource.getString("message.project")}));
			return;
		}
		if(mapping.getText().length()==0){
			updateStatus(Util.createMessage(resource.getString("error.required"),
					new String[]{resource.getString("message.mapping")}));
			return;
		}
//		try {
//			IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
//			IResource resource = root.findMember(new Path(container));
//			if(resource!=null){
//				if(!resource.exists()){
//					updateStatus(Util.createMessage(this.resource.getString("error.notexists"),
//							new String[]{container}));
//					return;
//				}
//				if(!resource.getProject().hasNature(StrutsPlugin.JAVA_PROJECT_NATURE)){
//					updateStatus(this.resource.getString("error.noJavaProject"));
//					return;
//				}
//			}
//		} catch(Exception ex){
//			ex.printStackTrace();
//		}
		updateStatus(null);
	}
	
	public String getWebAppRoot(){
		return this.containerText.getText();
	}
	
	public boolean getCreateStrutsConfigXML(){
		return this.strutsConfig.getSelection();
	}
	
	public boolean getCreateWebXML(){
		return this.webXml.getSelection();
	}
	
	public boolean getAddStrutsLibraries(){
		return this.library.getSelection();
	}
	
	public boolean getAddTLDFiles(){
		return this.tld.getSelection();
	}
	
	public boolean getCreateMessageResources(){
		return this.message.getSelection();
	}
	
	public String getMapping(){
		return this.mapping.getText();
	}
	
	private void updateStatus(String message) {
		setMessage(message, DialogPage.ERROR);
		setPageComplete(message == null);
	}

}
