/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.actions;

import java.util.ArrayList;
import java.util.List;
import net.sf.amateras.air.actions.AbstractAirEditorAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentAction
extends AbstractAirEditorAction {
    public void run(IAction action) {
        IDocument document = this.getTextEditor().getDocumentProvider().getDocument((Object)this.getTextEditor().getEditorInput());
        ITextSelection txtSel = (ITextSelection)this.getTextEditor().getSelectionProvider().getSelection();
        int start = this.getStart(document, txtSel.getOffset());
        int len = this.getLength(document, start, txtSel.getLength() + (txtSel.getOffset() - start));
        try {
            String selectedText = document.get(start, len);
            List<String> ret = CommentAction.splitInLines(selectedText);
            boolean isAllComment = true;
            for (String line : ret) {
                String v = line.replaceAll("\t", "");
                if (v.trim().startsWith("//")) continue;
                isAllComment = false;
                break;
            }
            int addTextSize = 0;
            StringBuilder strbuf = new StringBuilder(selectedText.length() + ret.size() + 2);
            for (String line : ret) {
                if (isAllComment) {
                    strbuf.append(line.replaceFirst("//", ""));
                    addTextSize -= 2;
                    continue;
                }
                strbuf.append("//").append(line);
                addTextSize += 2;
            }
            String replacement = strbuf.toString();
            document.replace(start, len, replacement);
            int selectLength = txtSel.getLength() + addTextSize;
            if (selectLength > 0 && txtSel.getLength() != 0) {
                this.getTextEditor().getSelectionProvider().setSelection((ISelection)new TextSelection(txtSel.getOffset(), selectLength));
            }
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> splitInLines(String string) {
        ArrayList<String> ret = new ArrayList<String>();
        int len = string.length();
        if (len == 0) {
            ret.add("");
            return ret;
        }
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            buf.append(c);
            if (c == '\r') {
                if (i < len - 1 && string.charAt(i + 1) == '\n') {
                    ++i;
                    buf.append('\n');
                }
                ret.add(buf.toString());
                buf = new StringBuilder();
            }
            if (c == '\n') {
                ret.add(buf.toString());
                buf = new StringBuilder();
            }
            ++i;
        }
        if (buf.length() != 0) {
            ret.add(buf.toString());
        }
        return ret;
    }

    private int getStart(IDocument document, int documentOffset) {
        if (documentOffset == 0) {
            return documentOffset;
        }
        try {
            char c;
            while ((c = document.getChar(--documentOffset)) != '\n' && c != '\r') {
            }
            return documentOffset + 1;
        }
        catch (BadLocationException badLocationException) {
            return documentOffset;
        }
    }

    private int getLength(IDocument document, int start, int length) {
        if (start + length == document.getLength()) {
            return length;
        }
        if (length > 0) {
            try {
                char c = document.getChar(start + length - 1);
                if (c == '\n' || c == '\r') {
                    return length;
                }
            }
            catch (BadLocationException badLocationException) {
                return length;
            }
        }
        int documentOffset = start + length;
        int maxSize = document.getLength();
        if (start >= maxSize) {
            return 0;
        }
        try {
            char c;
            while (((c = document.getChar(documentOffset)) == '\t' || c == ' ' || c == '/') && ++documentOffset < maxSize) {
            }
        }
        catch (BadLocationException badLocationException) {
            return documentOffset;
        }
        int newLength = documentOffset - start;
        return newLength;
    }
}

