/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.as;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.as.ActionScriptDoubleClickStrategy;
import net.sf.amateras.air.as.ActionScriptKeywordPartitionScanner;
import net.sf.amateras.air.as.CodeFormattingStrategy;
import net.sf.amateras.air.as.DefaultContentAssistProcessor;
import net.sf.amateras.air.as.EditorColorProvider;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class ActionScriptConfiguration
extends TextSourceViewerConfiguration {
    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__as_comment", "__as_string"};
    }

    private RuleBasedScanner getCommentScanner() {
        RuleBasedScanner scanner = new RuleBasedScanner();
        EditorColorProvider colorProvider = AIRPlugin.getDefault().getEditorColorProvider();
        scanner.setDefaultReturnToken(colorProvider.getToken("colorComment"));
        return scanner;
    }

    private RuleBasedScanner getStringScanner() {
        RuleBasedScanner scanner = new RuleBasedScanner();
        EditorColorProvider colorProvider = AIRPlugin.getDefault().getEditorColorProvider();
        scanner.setDefaultReturnToken(colorProvider.getToken("colorString"));
        return scanner;
    }

    private RuleBasedScanner getDefaultScanner() {
        return new ActionScriptKeywordPartitionScanner();
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer commentDR = new DefaultDamagerRepairer((ITokenScanner)this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)commentDR, "__as_comment");
        reconciler.setRepairer((IPresentationRepairer)commentDR, "__as_comment");
        DefaultDamagerRepairer stringDR = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)stringDR, "__as_string");
        reconciler.setRepairer((IPresentationRepairer)stringDR, "__as_string");
        DefaultDamagerRepairer keywordDR = new DefaultDamagerRepairer((ITokenScanner)this.getDefaultScanner());
        reconciler.setDamager((IPresentationDamager)keywordDR, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)keywordDR, "__dftl_partition_content_type");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        DefaultContentAssistProcessor processor = new DefaultContentAssistProcessor();
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        assistant.install((ITextViewer)sourceViewer);
        assistant.setProposalPopupOrientation(10);
        assistant.setContextInformationPopupOrientation(20);
        assistant.setProposalSelectorBackground(ColorConstants.tooltipBackground);
        assistant.enableAutoActivation(true);
        return assistant;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        IAutoEditStrategy[] strategies = new IAutoEditStrategy[]{new CodeFormattingStrategy()};
        return strategies;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return new ActionScriptDoubleClickStrategy();
    }
}

