/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.as.syntax;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import net.sf.amateras.air.as.syntax.DefaultSyntaxClass;
import net.sf.amateras.air.as.syntax.IContentAssistHelper;
import net.sf.amateras.air.as.syntax.ISyntaxClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleConstantAssistHelper
implements IContentAssistHelper {
    private static List<DefaultSyntaxClass> topLevel;

    @Override
    public List<ISyntaxClass> getSyntaxClasses(String document, int documentOffset, String previousWord) {
        ArrayList<ISyntaxClass> syntaxClasses = new ArrayList<ISyntaxClass>();
        if (previousWord.length() == 0) {
            return syntaxClasses;
        }
        if (topLevel == null) {
            this.loadTopLevel();
        }
        if (previousWord.endsWith("(")) {
            previousWord = previousWord.substring(0, previousWord.length() - 1);
        }
        int i = 0;
        while (i < topLevel.size()) {
            DefaultSyntaxClass syntax = topLevel.get(i);
            if (syntax.getName().startsWith(previousWord)) {
                syntax.setReplacementLength(previousWord.length());
                syntax.setReplacementOffset(documentOffset - previousWord.length());
                syntaxClasses.add(syntax);
            }
            ++i;
        }
        return syntaxClasses;
    }

    private void loadTopLevel() {
        String[] array;
        topLevel = new ArrayList<DefaultSyntaxClass>();
        String[] stringArray = array = this.readStreamToStringArray();
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String typeName = s.substring(0, s.indexOf(" "));
            String method = s.substring(s.indexOf(" ") + 1);
            DefaultSyntaxClass syntax = new DefaultSyntaxClass();
            if (typeName.equals("function")) {
                this.setFunctionProperty(method, syntax);
            } else if (typeName.equals("const")) {
                this.setConstantProperty(method, syntax);
            } else if (typeName.equals("property")) {
                this.setConstantProperty(method, syntax);
            }
            topLevel.add(syntax);
            ++n2;
        }
    }

    private void setFunctionProperty(String information, DefaultSyntaxClass syntax) {
        char[] array = information.toCharArray();
        StringBuilder methodName = new StringBuilder();
        StringBuilder argInfo = null;
        StringBuilder returnInfo = null;
        char[] cArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '(' && argInfo == null) {
                argInfo = new StringBuilder();
            } else if (c == ')' && returnInfo == null) {
                returnInfo = new StringBuilder();
            } else if (returnInfo != null) {
                returnInfo.append(c);
            } else if (argInfo != null) {
                argInfo.append(c);
            } else {
                methodName.append(c);
            }
            ++n2;
        }
        syntax.setReplacementString(String.valueOf(methodName.toString()) + "()");
        syntax.setCursorPosition(methodName.length() + 1);
        syntax.setType(2);
        syntax.setName(methodName.toString());
        syntax.setInformationDisplayString(argInfo.toString());
        syntax.setDisplayString(information);
    }

    private void setConstantProperty(String information, DefaultSyntaxClass syntax) {
        String methodName = information.substring(0, information.indexOf(":"));
        syntax.setReplacementString(methodName.toString());
        syntax.setCursorPosition(methodName.length());
        syntax.setType(5);
        syntax.setName(methodName);
        syntax.setDisplayString(information);
        syntax.setInformationDisplayString(information);
    }

    private String[] readStreamToStringArray() {
        BufferedReader bReader = null;
        InputStream input = null;
        try {
            String line;
            input = this.getClass().getResourceAsStream("/syntax/TopLevel");
            bReader = new BufferedReader(new InputStreamReader(input));
            ArrayList<String> list = new ArrayList<String>();
            while ((line = bReader.readLine()) != null) {
                if (line.length() == 0) continue;
                list.add(line);
            }
            String[] stringArray = list.toArray(new String[list.size()]);
            return stringArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        finally {
            try {
                if (bReader != null) {
                    bReader.close();
                }
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

