/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.as.syntax;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.as.syntax.IContentAssistHelper;
import net.sf.amateras.air.as.syntax.ISyntaxClass;
import net.sf.amateras.air.as.syntax.SampleConstantAssistHelper;
import net.sf.amateras.air.templates.ActionScriptTemplateCompletionProcessor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntaxReader {
    private String syntaxFileDirectory = "/syntax/";
    private static SyntaxReader myObject = new SyntaxReader();
    private String[] reservedWords;
    private IContentAssistHelper helper = new SampleConstantAssistHelper();

    private SyntaxReader() {
    }

    public static SyntaxReader getInstance() {
        return myObject;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        String previousWord = this.getPreviousWord(viewer.getDocument(), documentOffset);
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        this.addCompletionProposalsReservedWords(viewer, documentOffset, previousWord, result);
        viewer.getDocument().get();
        List<ISyntaxClass> lists = this.helper.getSyntaxClasses(viewer.getDocument().get(), documentOffset, previousWord);
        this.add(lists, result);
        this.addTemplateCompletionProposal(viewer, documentOffset, result);
        Collections.sort(result, new ASProposalComparator());
        return result.toArray(new ICompletionProposal[result.size()]);
    }

    protected void addTemplateCompletionProposal(ITextViewer viewer, int documentOffset, List<ICompletionProposal> result) {
        ICompletionProposal[] templateProposals;
        ActionScriptTemplateCompletionProcessor templateProcessor = new ActionScriptTemplateCompletionProcessor();
        ICompletionProposal[] iCompletionProposalArray = templateProposals = templateProcessor.computeCompletionProposals(viewer, documentOffset);
        int n = templateProposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal prop = iCompletionProposalArray[n2];
            result.add(prop);
            ++n2;
        }
    }

    protected void addCompletionProposalsReservedWords(ITextViewer viewer, int documentOffset, String previousWord, List<ICompletionProposal> result) {
        String[] reservedWords = this.getReservedWords();
        if (previousWord.length() > 0) {
            int i = 0;
            while (i < reservedWords.length) {
                if (reservedWords[i].startsWith(previousWord)) {
                    result.add((ICompletionProposal)new CompletionProposal(reservedWords[i], documentOffset - previousWord.length(), previousWord.length(), reservedWords[i].length(), this.getTypeImage(6), reservedWords[i], null, null));
                }
                ++i;
            }
        }
    }

    private void add(List<ISyntaxClass> syntaxClasses, List<ICompletionProposal> result) {
        int i = 0;
        while (i < syntaxClasses.size()) {
            ISyntaxClass syntax = syntaxClasses.get(i);
            ContextInformation context = null;
            if (syntax.getInformationDisplayString() != null) {
                context = new ContextInformation(null, syntax.getInformationDisplayString());
            }
            result.add((ICompletionProposal)new CompletionProposal(syntax.getReplacementString(), syntax.getReplacementOffset(), syntax.getReplacementLength(), syntax.getCursorPosition(), this.getTypeImage(syntax.getType()), syntax.getDisplayString(), (IContextInformation)context, syntax.getAdditionalInfo()));
            ++i;
        }
    }

    private String getPreviousWord(IDocument document, int documentOffset) {
        StringBuffer buf = new StringBuffer();
        try {
            while (true) {
                char c;
                if (Character.isWhitespace(c = document.getChar(--documentOffset)) || c == '}' || c == ':') {
                    return buf.reverse().toString();
                }
                buf.append(c);
            }
        }
        catch (BadLocationException badLocationException) {
            return buf.reverse().toString();
        }
    }

    public Image getTypeImage(int type) {
        if (type == 1) {
            return AIRPlugin.getDefault().getImageRegistry().get("CONTENTS_ASSIST_CLASS");
        }
        if (type == 3) {
            return AIRPlugin.getDefault().getImageRegistry().get("CONTENTS_ASSIST_PROERTY");
        }
        if (type == 2) {
            return AIRPlugin.getDefault().getImageRegistry().get("CONTENTS_ASSIST_METHOD");
        }
        if (type == 4) {
            return AIRPlugin.getDefault().getImageRegistry().get("CONTENTS_ASSIST_INTERFACE");
        }
        if (type == 5) {
            return AIRPlugin.getDefault().getImageRegistry().get("CONTENTS_ASSIST_RESERVED_WORD");
        }
        if (type == 6) {
            return AIRPlugin.getDefault().getImageRegistry().get("CONTENTS_ASSIST_RESERVED_WORD");
        }
        return null;
    }

    public String[] getReservedWords() {
        if (this.reservedWords == null) {
            this.reservedWords = this.readStreamToStringArray("ReservedWord");
        }
        return this.reservedWords;
    }

    private String[] readStreamToStringArray(String filePath) {
        BufferedReader bReader = null;
        InputStream input = null;
        try {
            String line;
            input = this.getClass().getResourceAsStream(String.valueOf(this.syntaxFileDirectory) + filePath);
            bReader = new BufferedReader(new InputStreamReader(input));
            ArrayList<String> list = new ArrayList<String>();
            while ((line = bReader.readLine()) != null) {
                if (line.length() == 0) continue;
                list.add(line);
            }
            String[] stringArray = list.toArray(new String[list.size()]);
            return stringArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        finally {
            try {
                if (bReader != null) {
                    bReader.close();
                }
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ASProposalComparator
    implements Comparator<ICompletionProposal> {
        @Override
        public int compare(ICompletionProposal p1, ICompletionProposal p2) {
            return p1.getDisplayString().compareTo(p2.getDisplayString());
        }
    }
}

