/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.builder;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompileProperty {
    public static final int MXML_TYPE = 1;
    public static final int AS3_TYPE = 2;
    private String directory;
    private int commandType = 1;
    private boolean isExtention = false;
    private String command = "";
    private String option = "";
    private List<String> targetFiles = new ArrayList<String>();

    public int getCommandType() {
        return this.commandType;
    }

    public void setCommandType(int type) {
        this.commandType = type;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getOption() {
        return this.option;
    }

    public void setOption(String option) {
        this.option = option;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public void addTargetFile(String fileName) {
        this.targetFiles.add(fileName);
    }

    public List<String> getTargetFiles() {
        return this.targetFiles;
    }

    public String toString() {
        return String.valueOf(this.directory.length() == 0 ? "{ROOT}" : this.directory) + " / " + (this.commandType == 1 ? "AirFlex" : "ActionScript");
    }

    public static List<CompileProperty> load(IPreferenceStore store) {
        String compiles = store.getString("flexCompiles");
        ArrayList<CompileProperty> result = new ArrayList<CompileProperty>();
        String[] dim = compiles.split("\n");
        int i = 0;
        while (i < dim.length) {
            String[] com = dim[i].split("\t");
            if (com.length >= 5) {
                CompileProperty prop = new CompileProperty();
                prop.setDirectory(com[0]);
                prop.setCommand(com[1]);
                prop.setOption(com[2]);
                prop.setCommandType(Integer.parseInt(com[3]));
                prop.setExtention(Boolean.parseBoolean(com[4]));
                result.add(prop);
            }
            ++i;
        }
        return result;
    }

    public static String export(List<CompileProperty> properties) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < properties.size()) {
            CompileProperty prop = properties.get(i);
            sb.append(prop.getDirectory()).append("\t");
            sb.append(prop.getCommand()).append("\t");
            sb.append(prop.getOption()).append("\t");
            sb.append(prop.getCommandType()).append("\t");
            sb.append(prop.isExtention()).append("\t");
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    public boolean isExtention() {
        return this.isExtention;
    }

    public void setExtention(boolean isExtention) {
        this.isExtention = isExtention;
    }
}

