/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.builder;

import java.io.File;
import java.io.IOException;
import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.util.ProcessUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.debug.ui.console.ConsoleColorProvider;
import org.eclipse.debug.ui.console.IConsoleColorProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.console.IConsoleManager;

public class FcshShell
implements IStreamListener {
    private Process process;
    private int workedIndex;
    private IProcess proc;
    private ProcessConsole console;
    private IProgressMonitor monitor;
    private boolean isFcshProcessEnd;
    private StringBuilder sb;

    public void startShell(File dir, IProgressMonitor monitor) throws IOException, CoreException {
        this.monitor = monitor;
        this.sb = new StringBuilder();
        IPreferenceStore store = AIRPlugin.getDefault().getPreferenceStore();
        String path = store.getString("fcshShellCommand");
        String sdkPath = ProcessUtil.getAirSdkPath(path);
        File fcsh = new File(sdkPath, path);
        monitor.setTaskName(AIRPlugin.getResourceString("COMPILE_START_SHELL"));
        this.process = ProcessUtil.createProcess(fcsh, dir);
        this.proc = DebugPlugin.newProcess((ILaunch)new Launch(null, "run", null), (Process)this.process, (String)("fcsh console [" + dir.getName() + "]"));
        this.console = new ProcessConsole(this.proc, (IConsoleColorProvider)new ConsoleColorProvider());
        this.console.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals(IConsoleConstants.P_CONSOLE_OUTPUT_COMPLETE)) {
                    FcshShell.this.stopShell();
                }
            }
        });
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        manager.addConsoles(new IConsole[]{this.console});
        manager.showConsoleView((IConsole)this.console);
        this.waitFcshProcessEnd();
        this.monitor = null;
    }

    public void streamAppended(String text, IStreamMonitor monitor) {
        this.sb.append(text);
        if (text.indexOf("(fcsh)") >= 0) {
            this.isFcshProcessEnd = true;
        }
    }

    private void waitFcshProcessEnd() {
        this.isFcshProcessEnd = false;
        this.proc.getStreamsProxy().getOutputStreamMonitor().addListener((IStreamListener)this);
        this.proc.getStreamsProxy().getErrorStreamMonitor().addListener((IStreamListener)this);
        while (!this.isFcshProcessEnd) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public String startCommand(String command, IProgressMonitor monitor) throws IOException {
        this.monitor = monitor;
        this.sb = new StringBuilder();
        System.out.println(command);
        this.sb.append(command);
        this.console.getInputStream().appendData(command);
        monitor.internalWorked((double)this.workedIndex++);
        this.waitFcshProcessEnd();
        this.monitor = null;
        return this.sb.toString();
    }

    public Process getProcess() {
        return this.process;
    }

    public void stopShell() {
        this.isFcshProcessEnd = true;
        if (this.monitor != null) {
            this.monitor.setCanceled(true);
            this.monitor = null;
        }
        if (this.console != null) {
            this.console.destroy();
            this.console = null;
        }
        if (this.proc != null) {
            try {
                this.proc.terminate();
            }
            catch (DebugException e) {
                DebugPlugin.log((Throwable)e);
            }
        }
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
            System.out.println(" stop Shell");
        }
    }

    public void setWorkdIndex(int index) {
        this.workedIndex = index;
    }
}

