/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.launch;

import java.io.File;
import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.launch.ADLRunner;
import net.sf.amateras.air.launch.LaunchAIRMainTab;
import net.sf.amateras.air.util.ProcessUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jface.preference.IPreferenceStore;

public class LaunchAIRConfiguration
extends LaunchConfigurationDelegate
implements IDebugEventSetListener {
    public static final String ID = "net.sf.amateras.air.launchAIRConfigurationType";

    public void handleDebugEvents(DebugEvent[] events) {
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        String projectName = configuration.getAttribute("air.project", "");
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        return new IProject[]{project};
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String projectName = configuration.getAttribute("air.project", "");
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        boolean isEnableDescriptorEx = LaunchAIRMainTab.isEnableDescriptorEx(configuration);
        String target = isEnableDescriptorEx ? configuration.getAttribute("air.target", "") : LaunchAIRMainTab.getProjectDescriptor(project);
        if (new File(target).exists()) {
            target = new File(target).getAbsolutePath();
        } else {
            IFile targetFile = project.getFile((IPath)new Path(target));
            target = targetFile.getLocation().toString();
        }
        if (!ProcessUtil.checkAirGearProject(project)) {
            return;
        }
        IPreferenceStore store = AIRPlugin.getDefault().getPreferenceStore();
        String adlpath = store.getString("adlCommand");
        String sdkPath = ProcessUtil.getAirSdkPath(adlpath);
        if (sdkPath == null) {
            return;
        }
        ADLRunner runner = new ADLRunner();
        runner.run(new File(sdkPath, adlpath), new String[]{target}, launch, monitor);
    }
}

