/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.mxml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.EventObject;
import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.mxml.MXMLLoader;
import net.sf.amateras.air.mxml.action.IStructuredSelectionRefresh;
import net.sf.amateras.air.mxml.editparts.MXMLEditPartFactory;
import net.sf.amateras.air.mxml.factory.MenuFactory;
import net.sf.amateras.air.mxml.factory.ModelFactory;
import net.sf.amateras.air.mxml.factory.TreeEditPartFactory;
import net.sf.amateras.air.mxml.models.IContainerModel;
import net.sf.amateras.air.mxml.models.RootModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gef.ui.actions.RedoRetargetAction;
import org.eclipse.gef.ui.actions.UndoRetargetAction;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.GraphicalEditorWithPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class VisualMXMLEditor
extends GraphicalEditorWithPalette
implements IResourceChangeListener {
    private RootModel root = new RootModel();
    private boolean savePreviouslyNeeded;
    private MXMLOutlinePage outline;
    private MenuFactory menuFactory;

    public VisualMXMLEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
        this.menuFactory = new MenuFactory(this);
        this.getActionRegistry().registerAction((IAction)new UndoRetargetAction());
        this.getActionRegistry().registerAction((IAction)new RedoRetargetAction());
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    protected PaletteRoot getPaletteRoot() {
        return ModelFactory.getPaletteRoot();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        if (selection instanceof IStructuredSelection) {
            for (IStructuredSelectionRefresh action : this.menuFactory.getRefreshActions()) {
                action.update((IStructuredSelection)selection);
            }
        }
    }

    public IAction getAction(Object key) {
        return this.getActionRegistry().getAction(key);
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setEditPartFactory((EditPartFactory)new MXMLEditPartFactory());
    }

    public IContainerModel getRootModel() {
        return this.root;
    }

    public void refreshGraphicalViewer() {
        this.root.removeAll();
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            try {
                IFile file = ((IFileEditorInput)input).getFile();
                MXMLLoader.loadMXML(file.getContents(), this.root);
                GraphicalViewer viewer = this.getGraphicalViewer();
                if (this.root.getChildren().size() > 0) {
                    viewer.setContents((Object)this.root.getChildren().get(0));
                }
            }
            catch (Exception ex) {
                AIRPlugin.logException(ex);
            }
        }
    }

    protected void initializeGraphicalViewer() {
        try {
            GraphicalViewer viewer = this.getGraphicalViewer();
            ScalableRootEditPart rootEditPart = new ScalableRootEditPart();
            viewer.setRootEditPart((RootEditPart)rootEditPart);
            this.refreshGraphicalViewer();
            final DeleteAction deleteAction = new DeleteAction((IWorkbenchPart)this);
            deleteAction.setSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
            this.getActionRegistry().registerAction((IAction)deleteAction);
            this.getGraphicalViewer().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    deleteAction.update();
                }
            });
            MenuManager menuMgr = this.menuFactory.createGraphicalViewerMenu();
            viewer.setContextMenu(menuMgr);
            this.getEditorSite().registerContextMenu("#VisualMXMLEditor", menuMgr, (ISelectionProvider)viewer);
            KeyHandler keyHandler = new KeyHandler();
            keyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
            this.getGraphicalViewer().setKeyHandler(new GraphicalViewerKeyHandler(this.getGraphicalViewer()).setParent(keyHandler));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setPartName(this.getEditorInput().getName());
    }

    public void doSave(IProgressMonitor monitor) {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            try {
                IFile file = ((IFileEditorInput)input).getFile();
                file.setContents((InputStream)new ByteArrayInputStream(this.root.toMXML().getBytes("UTF-8")), false, true, monitor);
            }
            catch (Exception ex) {
                AIRPlugin.logException(ex);
            }
        }
        this.setPartName(this.getEditorInput().getName());
        this.getCommandStack().markSaveLocation();
    }

    public void doSaveAs() {
        this.doSave((IProgressMonitor)new NullProgressMonitor());
    }

    public boolean isSaveOnCloseNeeded() {
        return this.getCommandStack().isDirty();
    }

    public boolean isDirty() {
        return this.isSaveOnCloseNeeded();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    private void setSavePreviouslyNeeded(boolean value) {
        this.savePreviouslyNeeded = value;
    }

    private boolean savePreviouslyNeeded() {
        return this.savePreviouslyNeeded;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IEditorInput input;
        if (event.getType() == 1 && (input = this.getEditorInput()) instanceof IFileEditorInput) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IFile file = ((IFileEditorInput)input).getFile();
                    if (!file.exists()) {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        page.closeEditor((IEditorPart)VisualMXMLEditor.this, false);
                    } else {
                        if (!VisualMXMLEditor.this.getPartName().equals(file.getName())) {
                            VisualMXMLEditor.this.setPartName(file.getName());
                        }
                        VisualMXMLEditor.this.refreshGraphicalViewer();
                    }
                }
            });
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void commandStackChanged(EventObject event) {
        if (this.isDirty()) {
            if (!this.savePreviouslyNeeded()) {
                this.setSavePreviouslyNeeded(true);
                this.firePropertyChange(257);
            }
        } else {
            this.setSavePreviouslyNeeded(false);
            this.firePropertyChange(257);
        }
        super.commandStackChanged(event);
    }

    public Object getAdapter(Class clazz) {
        if (IContentOutlinePage.class.equals((Object)clazz)) {
            if (this.outline == null) {
                this.outline = new MXMLOutlinePage();
            }
            return this.outline;
        }
        if (clazz == ZoomManager.class) {
            return ((ScalableRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        return super.getAdapter(clazz);
    }

    public MenuFactory getMenuFactory() {
        return this.menuFactory;
    }

    private class MXMLOutlinePage
    extends ContentOutlinePage {
        public MXMLOutlinePage() {
            super((EditPartViewer)new TreeViewer());
        }

        public void init(IPageSite pageSite) {
            super.init(pageSite);
            VisualMXMLEditor.this.menuFactory.setOutLinePageMenu(pageSite);
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            EditPartViewer viewer = this.getViewer();
            GraphicalViewer gviewer = VisualMXMLEditor.this.getGraphicalViewer();
            viewer.setEditDomain(gviewer.getEditDomain());
            this.getViewer().setEditPartFactory((EditPartFactory)new TreeEditPartFactory());
            viewer.setContextMenu((MenuManager)new OutlineContextMenuProvider());
            viewer.setContents((Object)VisualMXMLEditor.this.getRootModel());
            VisualMXMLEditor.this.getSelectionSynchronizer().addViewer(this.getViewer());
        }

        public EditPartViewer getViewer() {
            return super.getViewer();
        }

        public void dispose() {
            VisualMXMLEditor.this.getSelectionSynchronizer().removeViewer(this.getViewer());
            super.dispose();
        }
    }

    private class OutlineContextMenuProvider
    extends ContextMenuProvider {
        public OutlineContextMenuProvider() {
            super((EditPartViewer)VisualMXMLEditor.this.getGraphicalViewer());
        }

        public void buildContextMenu(IMenuManager menu) {
            VisualMXMLEditor.this.menuFactory.setOutLineContextMenu(menu);
        }
    }
}

