/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.mxml.descriptor;

import net.sf.amateras.air.mxml.descriptor.IEditorValueDescriptor;
import net.sf.amateras.air.mxml.descriptor.PropertyLabelDecoratorUtil;
import net.sf.amateras.air.mxml.models.AbstractModel;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanPropertyDescriptor
extends TextPropertyDescriptor
implements IEditorValueDescriptor<Boolean> {
    private Boolean defaultValue;

    public BooleanPropertyDescriptor(Object id, String displayName, Boolean defaultValue) {
        super(id, displayName);
        this.defaultValue = defaultValue;
        this.setLabelProvider((ILabelProvider)new MyLabelDecorator());
    }

    public CellEditor createPropertyEditor(Composite parent) {
        ComboBoxCellEditor editor = new ComboBoxCellEditor(parent, new String[]{"true", "false"}, 8){

            public void doSetValue(Object value) {
                if (value == null || value == AbstractModel.NULL_PROPERTY) {
                    super.doSetValue((Object)new Integer(-1));
                } else if (((Boolean)value).booleanValue()) {
                    super.doSetValue((Object)new Integer(0));
                } else {
                    super.doSetValue((Object)new Integer(1));
                }
            }

            public Object doGetValue() {
                int selection = (Integer)super.doGetValue();
                if (selection == -1) {
                    return AbstractModel.NULL_PROPERTY;
                }
                if (selection == 0) {
                    return new Boolean(true);
                }
                return new Boolean(false);
            }
        };
        if (this.getValidator() != null) {
            editor.setValidator(this.getValidator());
        }
        return editor;
    }

    @Override
    public Boolean getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Boolean getEditorValue(Boolean value) {
        if (value == null) {
            return this.defaultValue;
        }
        return value;
    }

    class MyLabelDecorator
    extends PropertyLabelDecoratorUtil {
        MyLabelDecorator() {
        }

        protected String getDefaultValue() {
            if (BooleanPropertyDescriptor.this.defaultValue == null) {
                return AbstractModel.NULL_PROPERTY;
            }
            return BooleanPropertyDescriptor.this.defaultValue.toString();
        }
    }
}

