/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.mxml.descriptor;

import net.sf.amateras.air.mxml.descriptor.IEditorValueDescriptor;
import net.sf.amateras.air.mxml.descriptor.PropertyLabelDecoratorUtil;
import net.sf.amateras.air.mxml.models.AbstractModel;
import net.sf.amateras.air.util.UIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.properties.PropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImagePropertyDescriptor
extends PropertyDescriptor
implements IEditorValueDescriptor<String> {
    private String defaultValue;

    public ImagePropertyDescriptor(Object id, String displayName, String defaultValue) {
        super(id, displayName);
        this.defaultValue = defaultValue;
        this.setLabelProvider((ILabelProvider)new PropertyLabelDecoratorUtil(defaultValue));
    }

    public CellEditor createPropertyEditor(Composite parent) {
        DialogCellEditor cellEditor = new DialogCellEditor(parent){

            protected Object openDialogBox(Control cellEditorWindow) {
                IEditorPart editorPart = UIUtil.getActiveEditor();
                IFileEditorInput input = (IFileEditorInput)editorPart.getEditorInput();
                IProject project = input.getFile().getProject();
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setInput((Object)ResourcesPlugin.getWorkspace());
                dialog.addFilter(new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        String name;
                        if (element instanceof IProject || element instanceof IFolder) {
                            return true;
                        }
                        return element instanceof IFile && ((name = ((IFile)element).getName()).endsWith(".png") || name.endsWith(".gif") || name.endsWith(".jpg") || name.endsWith(".jpeg"));
                    }
                });
                dialog.setAllowMultiple(false);
                dialog.setTitle("Icon");
                dialog.setInput((Object)project);
                if (dialog.open() == 0) {
                    String path = "";
                    if (input instanceof IFileEditorInput) {
                        int count = input.getFile().getProjectRelativePath().segmentCount() - 1;
                        int i = 0;
                        while (i < count) {
                            path = String.valueOf(path) + "../";
                            ++i;
                        }
                    }
                    path = String.valueOf(path) + ((IFile)dialog.getResult()[0]).getProjectRelativePath().toString();
                    return "@Embed('" + path + "')";
                }
                return AbstractModel.NULL_PROPERTY;
            }
        };
        return cellEditor;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getEditorValue(String value) {
        if (value != null && value.length() != 0) {
            return value;
        }
        if (this.defaultValue != null) {
            return this.defaultValue;
        }
        return AbstractModel.NULL_PROPERTY;
    }

    class MyLabelDecorator
    extends PropertyLabelDecoratorUtil {
        MyLabelDecorator() {
        }

        protected String getDefaultValue() {
            if (ImagePropertyDescriptor.this.defaultValue == null) {
                return AbstractModel.NULL_PROPERTY;
            }
            return ImagePropertyDescriptor.this.defaultValue.toString();
        }
    }
}

