/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.mxml.descriptor;

import net.sf.amateras.air.mxml.descriptor.IEditorValueDescriptor;
import net.sf.amateras.air.mxml.descriptor.PropertyLabelDecoratorUtil;
import net.sf.amateras.air.mxml.models.AbstractModel;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberPropertyDescriptor
extends TextPropertyDescriptor
implements IEditorValueDescriptor<Integer> {
    private Integer defaultValue;

    public NumberPropertyDescriptor(Object id, String displayName, Integer defaultValue) {
        super(id, displayName);
        this.setValidator(new NumberValidator());
        this.defaultValue = defaultValue;
        this.setLabelProvider((ILabelProvider)new MyLabelDecorator());
    }

    public CellEditor createPropertyEditor(Composite parent) {
        NumberCellEditor editor = new NumberCellEditor(parent);
        if (this.getValidator() != null) {
            editor.setValidator(this.getValidator());
        }
        return editor;
    }

    @Override
    public Integer getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Integer getEditorValue(Integer value) {
        if (value != null) {
            return value;
        }
        return this.defaultValue;
    }

    class MyLabelDecorator
    extends PropertyLabelDecoratorUtil {
        MyLabelDecorator() {
        }

        protected String getDefaultValue() {
            if (NumberPropertyDescriptor.this.defaultValue == null) {
                return AbstractModel.NULL_PROPERTY;
            }
            return NumberPropertyDescriptor.this.defaultValue.toString();
        }
    }

    class NumberCellEditor
    extends TextCellEditor {
        NumberCellEditor(Composite parent) {
            super(parent);
        }

        protected void doSetValue(Object value) {
            if (value == null || value == AbstractModel.NULL_PROPERTY) {
                this.text.setText(AbstractModel.NULL_PROPERTY);
            } else {
                Assert.isTrue((this.text != null && value instanceof Integer ? 1 : 0) != 0);
                this.text.setText(String.valueOf(value));
            }
        }

        protected Object doGetValue() {
            String value = this.text.getText();
            if (value == null || value.length() == 0) {
                return AbstractModel.NULL_PROPERTY;
            }
            return Integer.valueOf(value);
        }
    }

    class NumberValidator
    implements ICellEditorValidator {
        NumberValidator() {
        }

        public String isValid(Object value) {
            if (value != null && value.toString().length() > 0) {
                char[] charArray = value.toString().toCharArray();
                int i = 0;
                while (i < charArray.length) {
                    if (!(Character.isDigit(charArray[i]) || i == 0 && charArray[i] == '-')) {
                        return "The input value is not a numerical value. ";
                    }
                    ++i;
                }
                return null;
            }
            return null;
        }
    }
}

