/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.mxml.descriptor;

import net.sf.amateras.air.mxml.descriptor.IEditorValueDescriptor;
import net.sf.amateras.air.mxml.descriptor.PropertyLabelDecoratorUtil;
import net.sf.amateras.air.mxml.models.AbstractModel;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringListPropertyDescriptor
extends TextPropertyDescriptor
implements IEditorValueDescriptor<String> {
    private String[] list;
    private String defaultValue;

    public StringListPropertyDescriptor(Object id, String displayName, String[] list) {
        super(id, displayName);
        this.list = list;
        if (list.length > 0) {
            this.defaultValue = new String(list[0]);
        }
        this.setLabelProvider((ILabelProvider)new PropertyLabelDecoratorUtil(this.defaultValue));
    }

    public StringListPropertyDescriptor(Object id, String displayName, String[] list, String defaultValue) {
        super(id, displayName);
        this.list = list;
        this.defaultValue = new String(defaultValue);
        this.setLabelProvider((ILabelProvider)new PropertyLabelDecoratorUtil(defaultValue));
    }

    public CellEditor createPropertyEditor(Composite parent) {
        ComboBoxCellEditor editor = new ComboBoxCellEditor(parent, this.list, 0){

            public void doSetValue(Object value) {
                if (value == null || value == AbstractModel.NULL_PROPERTY) {
                    super.doSetValue((Object)new Integer(-1));
                } else {
                    int i = 0;
                    while (i < StringListPropertyDescriptor.this.list.length) {
                        if (StringListPropertyDescriptor.this.list[i].equalsIgnoreCase(value.toString())) {
                            super.doSetValue((Object)new Integer(i));
                            return;
                        }
                        ++i;
                    }
                    ((CCombo)super.getControl()).setText(value.toString());
                }
            }

            public Object doGetValue() {
                return ((CCombo)super.getControl()).getText();
            }
        };
        if (this.getValidator() != null) {
            editor.setValidator(this.getValidator());
        }
        return editor;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getEditorValue(String value) {
        if (value != null && value.length() != 0) {
            return value;
        }
        if (this.defaultValue != null) {
            return this.defaultValue;
        }
        return AbstractModel.NULL_PROPERTY;
    }
}

