/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amateras.air.mxml.descriptor;

import net.sf.amateras.air.mxml.descriptor.IEditorValueDescriptor;
import net.sf.amateras.air.mxml.descriptor.PropertyLabelDecoratorUtil;
import net.sf.amateras.air.mxml.models.AbstractModel;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WidthHeightPropertyDescriptor
extends TextPropertyDescriptor
implements IEditorValueDescriptor<String> {
    private String defaultValue;

    public WidthHeightPropertyDescriptor(Object id, String displayName, String defaultValue) {
        super(id, displayName);
        this.setValidator(new WidhtHeightValidator());
        this.defaultValue = defaultValue;
        this.setLabelProvider((ILabelProvider)new PropertyLabelDecoratorUtil(defaultValue));
    }

    public CellEditor createPropertyEditor(Composite parent) {
        WidthHeightCellEditor editor = new WidthHeightCellEditor(parent);
        if (this.getValidator() != null) {
            editor.setValidator(this.getValidator());
        }
        return editor;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getEditorValue(String value) {
        if (value != null && value.length() != 0) {
            return value;
        }
        return this.defaultValue;
    }

    class WidhtHeightValidator
    implements ICellEditorValidator {
        WidhtHeightValidator() {
        }

        public String isValid(Object value) {
            if (value != null && value.toString().length() > 0) {
                char[] charArray = value.toString().toCharArray();
                int i = 0;
                while (i < charArray.length) {
                    if (!(Character.isDigit(charArray[i]) || i == charArray.length - 1 && charArray[i] == '%')) {
                        return "The input value is not a numerical value. ";
                    }
                    ++i;
                }
                return null;
            }
            return null;
        }
    }

    class WidthHeightCellEditor
    extends TextCellEditor {
        WidthHeightCellEditor(Composite parent) {
            super(parent);
        }

        protected void doSetValue(Object value) {
            if (value == null) {
                this.text.setText(AbstractModel.NULL_PROPERTY);
            } else {
                Assert.isTrue((this.text != null ? 1 : 0) != 0);
                this.text.setText(String.valueOf(value));
            }
        }

        protected Object doGetValue() {
            String value = this.text.getText();
            if (value == null || value.length() == 0) {
                return AbstractModel.NULL_PROPERTY;
            }
            return value;
        }
    }
}

